// EZBLASTR.H		4-20-94

#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ON 1
#define OFF 0

/* GLOBAL VARIABLES */
char voc_file[256];
char far * pointer_to_sb_driver = 0;
unsigned int voc_status = 0;
unsigned char voc_hdr_length;
char far * voc_buf_address;

/* PROTOTYPES */
float get_driver_version(void);
void get_base_io_address(void);
void set_base_io_address(int io_address);
void get_DMA_interrupt(void);
void set_DMA_interrupt(int dma_interrupt);
int load_sb_driver(void);
void speaker(char set);
void status_address(void);
int play_voc(char far * voc_buf_address);
int start_voice_input(char far *input_buf_adrs,long length,int sample_rate);
void voc_stop(char far * pointer_to_sb_driver);
void sb_free(void);
int pause_voice_output(void);
int continue_voice_output(void);
int break_voice_output_loop(int exitwhen);
int set_record_mode(int mode);
int set_record_source(int source);
int set_record_filter(int filter);
void set_DMA_channel(int channel);
int get_card_type(void);
int filter_on_off(int process, int mode);
long get_sample_rate(int process, int mode);
int read_filter_status(int process);

/* misc. functions */
char far * load_voc(char * filename_s);
void voc_free(char far * voc_buf_address);

/* CALLING CONVENTIONS

	 	if (load_sb_driver() == -1)
		{
			printf("Error loading driver");
			exit(0);
		}

		voc_buf_address = load_voc(voc_file);

		play_voc(voc_buf_address);
*/

