// ez.c
//
// Borland C++ 3.1
// Sample program which shows how to hook the EasyWin window class
// in order to install a menubar and respond to window messages
//
// A special thanks to Paul A. LeBlanc of BCPPWIN (TeamB) for help
// in showing me how to do this.
//
// Public Domain 1994
// no liability accepted for any reason
//

#include <windows.h>
#include <stdio.h>


#pragma argsused
#define IDM_EXIT  100
#define IDM_ABOUT 101

LRESULT CALLBACK _export MainWndProc(HWND hwnd, UINT msg,
                                  WPARAM wParam, LPARAM lParam);
FARPROC OldWndProc;
void MyInitEasyWin(void);
void ShowMenu(void);


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpszCmdLine, int cmdShow)
{
   MyInitEasyWin();
   ShowMenu();
   printf("Hello subclassed EasyWin world!\n");
   return 0;
}


LRESULT CALLBACK _export MainWndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
   switch(wMessage)
   {
       case WM_CHAR :
	  {
          MessageBeep(0);
          break;
          }
       case WM_LBUTTONDOWN :
	  {
          MessageBox(0,"Left button","Mouse",MB_OK);
          break;
          }
       case WM_COMMAND :
          if(!LOWORD(lParam))
          {                   
             switch(wParam)            
             {
	     case IDM_EXIT :
		{
                 PostQuitMessage(0);
		}
                break;
	     case IDM_ABOUT :
		{
		  clrscr();
		  puts("This sample program is public domain 1994 by");
		  puts("Mike Caughran Cedar Island Software");
		  puts("");
		  puts("Use it as you see fit.");
                  puts("All the usual disclaimers apply.");
		}
                break;
             }
          }

          break;

       default :
	  return CallWindowProc(OldWndProc, hWnd, wMessage, wParam, lParam);

   }
   return 0L;
}

void MyInitEasyWin()
 {
   extern HINSTANCE _hInstance;
   WNDCLASS wc;
   GetClassInfo(_hInstance, "BCEasyWin", &wc);
   UnregisterClass("BCEasyWin", _hInstance);
   //wc.hbrBackground = CreateSolidBrush(RGB(0,0,0));
   OldWndProc = (FARPROC) wc.lpfnWndProc;
   wc.lpfnWndProc = MainWndProc;
   RegisterClass(&wc);
   _InitEasyWin();
 }

void ShowMenu()
{
   HMENU Menu;
   HMENU FileMenu;
   Menu = CreateMenu();
   FileMenu = CreateMenu();
   AppendMenu(Menu, MF_POPUP, FileMenu, "File");
   AppendMenu(FileMenu, MF_ENABLED, IDM_EXIT, "Exit");
   AppendMenu(Menu, MF_ENABLED, IDM_ABOUT, "About");
   SetMenu(GetActiveWindow(),Menu);
}

