/****************************************************************************
* extlib.h - definitions for the Extended Library 1.0
*
*   Copyright (c) 1988 By Mark D. Goodwin
****************************************************************************/

/* logic constants */
#define TRUE 1
#define FALSE 0

/* display type constants */
#define _IBM_CGA 0
#define _NONIBM_CGA 1

/* border line constants */
#define _DOUBLE_LINE 0
#define _SINGLE_LINE 1
#define _NO_BORDER 2

/* joystick constants */
#define _BUTTON_A_1 0
#define _BUTTON_A_2 1
#define _BUTTON_B_1 2
#define _BUTTON_B_2 3
#define _STICK_A_X 0
#define _STICK_A_Y 1
#define _STICK_B_X 2
#define _STICK_B_Y 3

/* input constants */
#define _INPUT 0
#define _DISPLAY_ONLY 1
#define _STRING 0
#define _DOLLARS 1
#define _NUMBER 2

/* window constants */
#define _DRAW 1
#define _NO_DRAW 0
#define _UP 0
#define _DOWN 1
#define _LEFT 2
#define _RIGHT 3

/* boolean data type */
typedef int boolean;

/* pull down menu structure definitions */
typedef struct {
	char string[31];
	int hotkey;
	int (*function)();
} MENU;

typedef struct {
	char heading[21];
	int hotkey, number;
	MENU *mptr;
} MENU_HEAD;

/* window structure definition */
typedef struct {
   int row1, col1, row2, col2;
   char *videoarray;
} WINDOW ;

/* external variable declarations */
extern int nonibm;
extern int cursorstart, cursorend;
extern int _pdatt1, _pdatt2, _pdatt3;
extern int _puatt1, _puatt2, _puatt3;
extern int _mmatt1, _mmatt2, _mmatt3;
extern int _mbatt1, _mbatt2;

/* function prototypes */
void clearone(int, int, int);
void clearscreen(int, int, int, int, int);
WINDOW *close_window(WINDOW *);
void cursoroff(void);
void cursoron(void);
void display_error(char *);
void display_menu_bar(int, MENU *, int);
void drawbox(int, int, int, int, int, int);
void draw_window(int, int, int, int, int, int, ...);
void error_handler(unsigned, unsigned, unsigned far *);
void fillone(int, int, int, int);
void fillscreen(int, int, int, int, int, int);
int fire(int);
void getcurpos(int *, int *, int *, int *);
void horizontal_bar(WINDOW *, int, int, int);
void hotstring(int, int, int, int, char *);
int inputdollars(int, int, int, int, double *);
void inputfields(int, int, ...);
int inputnumber(int, int, int, int, unsigned long *);
int inputstring(int, int, int, int, char *);
int menu_bar(int, MENU *, int);
void menuline(int, int, int);
int mini_menu(int, int, int, MENU *, int, ...);
WINDOW *open_window(int, int, int, int, int, ...);
int popup(int, MENU *, int, int);
void printcenter(int, int, char *);
void printdelimit(int, int, int, ...);
void printfields(int, ...);
void printheads(int, ...);
void printone(int, int, int);
void printstring(int, int, char *);
void pulldown_bar(int, MENU_HEAD *, int);
int pulldown(int, MENU_HEAD *, int);
void restorescreen(int, int, int, int, char *);
void save_initial_video(void);
void savescreen(int, int, int, int, char *);
void scroll_window(WINDOW *, int, int, int);
void setattrib(int, int, int, int, int);
void setone(int, int, int);
void setcurpos(int, int);
void setcursor(int, int);
void settext80(void);
int stick(int);
void vertical_bar(WINDOW *, int, int, int);
int waitkey(void);
