/****************************************************************************
* extlib.h - Header file for EXTLIB 2.0
*            Copyright (c) 1989 By Maine Data and Financial Systems, Inc.
****************************************************************************/
#ifndef EXTLIB
#define EXTLIB

#ifdef LATTICE
#define max(a, b) (((a) > (b)) ? (a) : (b))
#define nonibm _nonibm
#define mouse_flag _mouse_flag
#define mouse_row _mouse_row
#define mouse_col _mouse_col
#define left_button _left_button
#define center_button _center_button
#define right_button _right_button
#define fillscreen _fillscreen
#define hidemouse _hidemouse
#define keypressed _keypressed
#define movescreen _movescreen
#define printstring _printstring
#define readmouse _readmouse
#define restorescreen _restorescreen
#define resetmouse _resetmouse
#define savescreen _savescreen
#define setattrib _setattrib
#define settext80 _settext80
#define showmouse _showmouse
#define waitkey _waitkey
#define NULL 0L
#endif

/* logic constants */
#define TRUE 1
#define FALSE 0

/* display type constants */
#define IBM_CGA 0
#define NONIBM_CGA 1

/* border line constants */
#define DOUBLE_LINE 0
#define SINGLE_LINE 1
#define NO_BORDER 2

/* window constants */
#define NO_CLEAR 0
#define CLEAR 1
#define NO_SCROLL 0
#define SCROLL 1
#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3

/* boolean data type */
typedef int boolean;

/* structure declarations */
typedef struct {
	char *string;
	int hotkey;
	void (*function)(void);
	void (*help)(void);
} MENU;

typedef struct {
	char *heading;
	int hotkey, number;
	MENU *mptr;
} MENU_HEAD;

typedef struct {
	int month, day, year;
} DATE;

typedef struct {
	int area, exchange, no;
} PHONE ;

typedef struct {
	int no1, no2, no3;
} SSN ;

typedef struct {
	int row1, col1, row2, col2, watt, bflg, sflg;
	char *buffer;
	int orow, ocol, ostart, oend;
	int crow, ccol;
} WINDOW ;

/* external variable declarations */
extern int nonibm;
extern int mouse_flag, mouse_row, mouse_col;
extern int left_button, center_button, right_button;
extern int menu_att, menu_hotkey, menu_highlight;

/* macro definitions */
#define clearone(row, col, att)\
		fillone(row, col, ' ', att)
#define clearscreen(row1, col1, row2, col2, att)\
		fillscreen(row1, col1, row2, col2, ' ', att)
#define fillrow(row, col1, col2, chr, att)\
		fillscreen(row, col1, row, col2, chr, att)
#define fillcolumn(row1, col, row2, chr, att)\
		fillscreen(row1, col, row2, col, chr, att)
#define clearrow(row, col1, col2, att)\
		fillrow(row, col1, col2, ' ', att)
#define clearcolumn(row1, col, row2, att)\
		fillcolumn(row1, col, row2, ' ', att)

/* function prototypes */
void cursoroff(void);
void cursoron(void);
char *date_string(char *, DATE *);
int dialog(int, int, int, MENU *, int, int, ...);
void display_date(int, int, DATE *);
void display_dollar(int, int, int, double *);
void display_number(int, int, int, unsigned long *);
void display_phone(int, int, PHONE *);
void display_ssn(int, int, SSN *);
void display_string(int, int, int, char *);
void w_draw(int, int, int, int, int, int);
void drawborder(int, int, int, int, int, int);
void fillone(int, int, int, int);
void far fillscreen(int, int, int, int, int, int);
void far hidemouse(void);
void getcurpos(int *, int *, int *, int *);
void hotstring(int, int, int, char *);
int input_date(int, int, DATE *);
int input_dollar(int, int, int, double *);
int input_number(int, int, int, unsigned long *);
int input_phone(int, int, PHONE *);
int input_ssn(int, int, SSN *);
int input_string(int, int, int, char *);
int far keypressed(void);
void far movescreen(int, int, int, int, int, int);
char *phone_string(char *, PHONE *);
int popup(int, int, int, MENU *, int);
void printcenter(int, int, char *);
void printone(int, int, int);
void far printstring(int, int, char far *);
int pulldown(int, int, MENU_HEAD *, int, void(*)(void));
void pulldown_bar(int, int, MENU_HEAD *);
void far readmouse(void);
void far resetmouse(void);
void far restorescreen(int, int, int, int, char far *);
void save_initial_video(void);
void far savescreen(int, int, int, int, char far *);
void far setattrib(int, int, int, int, int);
void setone(int, int, int);
void setcurpos(int, int);
void setcursor(int, int);
void far settext80(void);
void far showmouse(void);
char *ssn_string(char *, SSN *);
int far waitkey(void);
WINDOW *w_open(int, int, int, int, int, ...);
WINDOW *w_close(WINDOW *);
void w_setcurpos(WINDOW *, int, int);
void w_cls(WINDOW *);
void w_clreol(WINDOW *);
void w_scroll(WINDOW *, int, int, boolean);
void w_horizontal_bar(WINDOW *, int, int);
void w_vertical_bar(WINDOW *, int, int);
void w_print(WINDOW *, char *);
void w_println(WINDOW *, char *);
void w_printat(WINDOW *, int, int, char *);
void w_printlnat(WINDOW *, int, int, char *);
int w_printf(WINDOW *, int, int, char *, ... );
int wprintf(int, int, char *, ... );

#endif

