/*
 *  ExitWin.cpp: Quick Windows Exit Program v1.0 -  1992, ric Trpanier
 */
        
#include <owl.h>
#include "exitwinr.h"

// If there was a few more strings, I would probably have to move
// them into resource storage, but for the moment I keep them as
// global variables.

char AppName[]	   = "Exit Windows";  
char WndClass[]	   = "TExitWnd";
char ConfExit[]	   = "ConfirmExit";	// INI profile entry name

char ConfirmText[] = "This will end your Windows session.";

char AboutText[]   = "Quick Windows Exit Program v1.0\n"
		     " 1992, ric Trpanier\n\n"
		     "CompuServe:\t71042,3207\n"
		     "Internet:\t\teric@tgm.CAM.ORG";

char szHelpAbout[]   = "&About...";
char szConfirmExit[] = "Confirm &Exit";
char szExitWin[]     = "E&xit Windows...";

#define CM_HELPABOUT   101
#define CM_CONFIRMEXIT 102
#define CM_EXITWIN     103

class TExitApp: public TApplication
{
public:
    TExitApp(LPSTR AName, HINSTANCE AnInstance, HINSTANCE APrevInstance,
	LPSTR ACmdLine, int ACmdShow) : TApplication(AName, AnInstance,
	    APrevInstance, ACmdLine, ACmdShow) {};
    virtual void InitMainWindow();
};

class TExitWnd: public TWindow
{
protected:
    BOOL ConfirmExit;

public:
    TExitWnd(PTWindowsObject AParent, LPSTR ATitle);
    virtual ~TExitWnd();

    virtual LPSTR GetClassName() { return WndClass; };
    virtual void GetWindowClass(WNDCLASS& AWndClass);
    virtual void SetupWindow();

    virtual void WMQueryOpen(RTMessage Msg)
	= [WM_FIRST + WM_QUERYOPEN];
    virtual void WMSysCommand(RTMessage Msg)
     	= [WM_FIRST + WM_SYSCOMMAND];

    // Fake virtual response methods, these are manually
    // called from WM_SYSCOMMAND:
     
    void CMHelpAbout();
    void CMConfirmExit();
    void CMExitWin();

    BOOL GetConfirm() { return ConfirmExit; };
    void SetConfirm(BOOL c) { ConfirmExit = c; };
    void UpdateMenu();
};

void TExitApp::InitMainWindow()
{
    MainWindow = new TExitWnd(NULL, AppName);
}

TExitWnd::TExitWnd(PTWindowsObject AParent, LPSTR ATitle):
    TWindow(AParent, ATitle)
{
    // The condition is necessary to make sure SetConfirm() is
    // called with either 0 or 1

    SetConfirm(GetProfileInt(AppName, ConfExit, 1) ? 1 : 0);
}

TExitWnd::~TExitWnd()
{
    char Buf[2];

    WriteProfileString(AppName, ConfExit, itoa(GetConfirm(), Buf, sizeof Buf));
}

void TExitWnd::GetWindowClass(WNDCLASS& AWndClass)
{
    TWindow::GetWindowClass(AWndClass);
    AWndClass.hIcon = LoadIcon(AWndClass.hInstance, MAKEINTRESOURCE(APPICON));
}

void TExitWnd::SetupWindow()
{
    TWindow::SetupWindow();

    HMENU SysMenu = GetSystemMenu(HWindow, FALSE);
    RemoveMenu(SysMenu, SC_SIZE, MF_BYCOMMAND);
    RemoveMenu(SysMenu, SC_MINIMIZE, MF_BYCOMMAND);
    RemoveMenu(SysMenu, SC_MAXIMIZE, MF_BYCOMMAND);
    AppendMenu(SysMenu, MF_SEPARATOR, 0, NULL);
    AppendMenu(SysMenu, MF_STRING, CM_HELPABOUT, szHelpAbout);
    AppendMenu(SysMenu, MF_STRING, CM_CONFIRMEXIT, szConfirmExit);
    AppendMenu(SysMenu, MF_STRING, CM_EXITWIN, szExitWin);
    UpdateMenu();
}

void TExitWnd::CMHelpAbout()
{
    MessageBox(HWindow, AboutText, AppName, MB_ICONINFORMATION | MB_OK);
}

void TExitWnd::CMConfirmExit()
{
    SetConfirm(GetConfirm() ? 0 : 1);
    UpdateMenu();
}

void TExitWnd::CMExitWin()
{
    int Result = IDOK;

    if (GetConfirm()) {
	MessageBeep(MB_ICONINFORMATION);

	Result = MessageBox(HWindow, ConfirmText, AppName,
			    MB_ICONINFORMATION | MB_OKCANCEL);
    }
    if (Result == IDOK)
	ExitWindows(0, 0);
}

void TExitWnd::WMQueryOpen(RTMessage Msg)
{
    CMExitWin();
    Msg.Result = 0;
}

void TExitWnd::WMSysCommand(RTMessage Msg)
{
    switch (Msg.WParam) {
    case CM_HELPABOUT:
	CMHelpAbout();
        break;
    case CM_CONFIRMEXIT:
	CMConfirmExit();
        break;
    case CM_EXITWIN:
	CMExitWin();
	break;
    default:
	DefWndProc(Msg);
    }
}

void TExitWnd::UpdateMenu()
{
    char* Buf = szExitWin;
    HMENU SysMenu = GetSystemMenu(HWindow, FALSE);

    // Put a checkmark in the menu if ConfExit is enabled
    UINT Check = GetConfirm() ? MF_CHECKED : MF_UNCHECKED;
    CheckMenuItem(SysMenu, CM_CONFIRMEXIT, MF_BYCOMMAND | Check);

    // Append a trailing ellipsis to "Exit Windows" if ConfExit is enabled
    Buf[sizeof(szExitWin)-4] = GetConfirm() ? '.' : 0;
    ModifyMenu(SysMenu, CM_EXITWIN, MF_BYCOMMAND | MF_STRING, CM_EXITWIN, Buf);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    HWND hPrevWnd = FindWindow(WndClass, AppName);

    if (hPrevWnd) 
	return int(SendMessage(hPrevWnd, WM_SYSCOMMAND, CM_EXITWIN, 0L));
    else {
	nCmdShow = SW_MINIMIZE;
	TExitApp ExitApp(AppName, hInstance, hPrevInstance, lpCmdLine, nCmdShow);
	ExitApp.Run();
	return ExitApp.Status;
    }
}
