#include <owl\dialog.h>
#include <owl\applicat.h>
#include "edialog.h"
//
// Structure for holding windows to disable
//
struct TEnumInfo {
  short     Count;
  HWND far* Wnds;
};
//
// Simplified from TApplication::DisableWnds
//
// Note this is called before the dialog is created and does not
// disable the windows
//
// Firstly called to count up the windows to be stored
// then called to save the windows
//
BOOL far _export _pascal
EnumerateActiveWnds(HWND wnd, TEnumInfo* info)
	{
	if (!(::GetWindowLong(wnd, GWL_STYLE) & WS_CHILD))
		{
			if (::IsWindowEnabled(wnd))
				if (!info->Wnds) // counting windows to determine buffer size
					info->Count++;
				else
					*(info->Wnds++) = wnd;
		}
	return TRUE;
	}
TEDialog::TEDialog(TWindow * AParent,TResId resid,TModule* module)
		: TDialog(AParent,resid, module)
		{
			executingModally = FALSE;
		 }
//
// This is it. Note that this assumes WS_VISIBLE is set for the dialog
// Execute always shows the dialogs
//
int TEDialog::ExecuteModally()
	{
			  TEnumInfo ei = { 0, 0 };
			  wnds = 0;

			  // Set modal state
			  //
				if (!EnumTaskWindows(GetCurrentTask(), (WNDENUMPROC)EnumerateActiveWnds,
							(LPARAM)(TEnumInfo far*)&ei))
					return -1;

				// Allocate list of windows to disable, disable windows that are
				// enabled and then stuff them into the list.
				//
				ei.Wnds = wnds = new HWND[ei.Count + 1];
				memset(wnds, 0, sizeof(HWND)*(ei.Count + 1));

				EnumTaskWindows(GetCurrentTask(), (WNDENUMPROC)EnumerateActiveWnds,
							 (LPARAM)(TEnumInfo far*)&ei);

		if (Create())
			{
			  executingModally = TRUE;
				if (wnds)
					for (HWND* wnd = wnds; *wnd; wnd++)
						::EnableWindow(*wnd, FALSE);
				return GetApplication()->MessageLoop();
			}
		return -1;
	}

//
// If executing Modally, ensure the fake method of closing
// is used. Normally Modal and Modeless dialogs close in different
// ways. (Especially modal dialog OWL objects are not destroyed).
//
void TEDialog::Destroy(int Return)
	{
		if (executingModally)
			{
  //
  // Re-enable window(s) that are disabled in BeginModal()
  // before the dialog is destroyed so that application remains active
  //
				if (wnds)
					for (HWND* wnd = wnds; *wnd; wnd++)
						::EnableWindow(*wnd, TRUE);
				delete wnds;

				executingModally = FALSE;
				GetApplication()->EndModal(Return);
			}
		TDialog::Destroy(Return);
	}
void TEDialog::CloseWindow(int returnValue)
	{
		if (executingModally) // get my variation
			{
				if (CanClose())
					{
				      TransferData(tdGetData);
						Destroy(returnValue);
					}
			}
		else
			TDialog::CloseWindow(returnValue);
	}
