/***************************************************************************
Memory class|
-------------
Purpose:
	To provide a easy way to allocate memory and swap it to EMS memory and
virtual memory.
***************************************************************************/
#include "cems.h" //EMS stuff header
#include "file.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <alloc.h>
#include <conio.h>
#include <io.h>
#include <dir.h>
#include <dos.h>
#include "memory.h"

int (*_memhandler)(long bytes,Memory *M);
/* required for 64K+ writes*/

int DISK_AV=0;
int EMS_AV=0;

char *current_directory(char *path)
{
	strcpy(path, "X:\\");      /* fill string with form of response: X:\ */
	path[0] = 'A' + getdisk();    /* replace X with current drive letter */
	getcurdir(0, path+3);  /* fill rest of string with current directory */
	return(path);
}
int DFMemHandle(long bytes,Memory *M)
{
	_AH=0;
	_AL=3;
	geninterrupt(0x10);
	printf("Memory Error #A000: Low on Conventional Memory\n");
	printf("%ld bytes needed, only %ld byte available\n",bytes,farcoreleft());
//	printf("Free Heap: %ld Bytes\n",farcoreleft());

	exit(-1);
//   return 0 for failure, 1 for success;
}
void Init(int needed,int neededone,char name[255],int Display)
{
	int dummy;
	_memhandler=DFMemHandle;
	if(Display)
		printf("Loading %s...\n",name);
	if(ems_present()==1 && ems_version() > 0x30)
	{
		if(Display)
			printf("Expanded memory detected.\n");
		if(ems_pages(&dummy) >1)
		{
			if(Display)
				printf("Expanded memory fully used.\n");
			EMS_AV=ems_pages(&dummy);
		}
		else
			if(Display)
				printf("Expanded memory cannot be used.\n");
	}
	char *drive;
	drive=getenv("TMP");

	if(drive==NULL)
	{
		drive=new char[255];
		current_directory(drive);
	}
	drive[0]=toupper(drive[0]);
	drive[0]=drive[0]-'A';
	struct dfree free;
	long avail;
	getdfree((int)drive[0]+1, &free);
	avail =   (long) free.df_avail
				* (long) free.df_bsec
				* (long) free.df_sclus;
	DISK_AV=(int)(avail/16384);
	drive[0]=drive[0]+'A';
	int problem=0;
	if(EMS_AV < neededone && DISK_AV < neededone)
	{
error:
		printf("\nYou do not have enough memory to run %s\n",name);
		printf("You can either free up disk space on drive %c or\n",drive[0]);
		printf("free up more expanded memory.\n\n");
		if(problem==1)
			printf("%s requires %dK total extra memory.\n",name,needed*16);
		else
			printf("%s requires either EMS or VIRTUAL memory to have %dK free.\n\n",name,neededone*16);
		printf("Press any key to continue.\n");
		getch();
		exit(-1);
	}
	if(EMS_AV+DISK_AV < needed)
	{
		problem=1;
		goto error;
	}

}

	Memory::Memory()
	{
		strcpy(SWAP_FileName,tempnam("","TMP"));
		//Allocate(0); // call main allocate w/ 0
		SWAP_TYPE=0;
	}
	Memory::Memory(long s)
	{
		strcpy(SWAP_FileName,tempnam("","TMP"));
		Allocate(s); //pass on to allocate
		SWAP_TYPE=0;
	}
	Memory::~Memory()
	{
		Deallocate(); //free up memory
	}
	int Memory::SwapBack()
	{
		if(SWAP_TYPE==0)
			return 1;
		int s=SWAP_TYPE;
		Allocate(size);
		SWAP_TYPE=s;
		switch(SWAP_TYPE)
		{
			case SWAP_DISK:
				FILE *fp;
				fp=fopen(SWAP_FileName,"rb");
				BIG_Read((char huge *)pointer,size,fp);
				fclose(fp);
				unlink(SWAP_FileName);
				DISK_AV+=pages;
				break;
			case SWAP_EMS:
				void far *ems_loc=MK_FP(ems_pfa(),0);
				for(int a=0;a < pages;a++)
				{
					ems_map(EMS_HANDLE,a,a);
				}
				_fmemcpy((void far *)pointer,ems_loc,size);
				EMS_AV+=pages;
				ems_free(EMS_HANDLE);
				break;

		}
		SWAP_TYPE=0;
		return 1;
	}
	int Memory::Swap(int s) //returns 0 for success, 1 for failure
	{
	again:
		switch(s)
		{
			case SWAP_DISK:
				if(DISK_AV < pages)
					return 0;
				FILE *fp;
				fp=fopen(SWAP_FileName,"wb");
				BIG_Write((char huge *)pointer,size,fp);
				fclose(fp);
				DISK_AV-=pages;
				break;
			case SWAP_EMS:
				void far *ems_loc=MK_FP(ems_pfa(),0);
				if(EMS_AV < pages)
					return 0;
				EMS_HANDLE=ems_alloc(pages);
				for(int a=0;a < pages;a++)
				{
					ems_map(EMS_HANDLE,a,a);
				}
				_fmemcpy(ems_loc,(void far *)pointer,size);
				EMS_AV-=pages;
				break;
			case SWAP_BEST:
				if(EMS_AV >= pages)
					s=SWAP_EMS;
				else
					s=SWAP_DISK;
				goto again;
		}
		SWAP_TYPE=0;
		farfree((void huge *)pointer);
		SWAP_TYPE=s;
		return 0;
	}

	void Memory::Allocate(long s)
	{
		size=s;
		pages=0;
		if(s < 16384)
			pages=1;
		else
		{
			pages=(s/16384);
			if(s%16384)
				pages++;
		}

		SWAP_TYPE=0;//conventional (for now...)
		pointer=(void huge *)farmalloc((long)pages * (long)16384);
		if(pointer==NULL)
		{
			_memhandler(s,this);
			exit(-1);
		}
		_fmemset(pointer,0,s);

	}
	void Memory::Deallocate()
	{
		if(pointer==NULL)
			return;
		switch(SWAP_TYPE) //what type of memory
		{
			case 0:
				farfree((void far*)pointer);
				break;
			case SWAP_DISK:
				unlink(SWAP_FileName);
				break;
			case SWAP_EMS:
				ems_free(EMS_HANDLE);
				break;

		}
	}
	void huge *Memory::ReturnAddress()
	{
		return pointer;
	}
	Memory::operator void huge *()
	{
		return pointer;
	}

	Memory::operator char far *()
	{
		return (char huge *)pointer;
	}
void SetMemoryHandler(int (*mh)(long,Memory *M))
{
	_memhandler=mh;
}

