#if !defined (TMENUBAR)                   // To prevent multiple declarations
#define TMENUBAR

// ---- Library Header Files ------------------------------------------------

#include <conio.h>


// ---- Macros --------------------------------------------------------------

#include "evmacros.hpp"


// ---- Type Definitions ----------------------------------------------------

#include "twindow.hpp"
#include "tstatusline.hpp"


struct tmenuitem                                             // One menu item
{
   char huge *itemtext ;                                         // Item text
   int       hotkey ;                       // Hotkey for this item (A-Z & 0)
   int       itemrow ;                               // Row of item in window
   int       returnvalue ;                      // Return value for this item
   int       availflag ;              // TRUE: available FALSE: not available
   char huge *sltext ;                            // Help text for statusline
   tmenuitem huge *nextitem ;                            // Next item in link
   tmenuitem huge *previousitem ;                    // Previous item in link
} ;


struct tmenu                                                      // One menu
{
   char huge  *name ;                                         // Name of menu
   int        hotkey ;                                // Hotkey of menu (A-Z)
   int        colpos ;                              // Column postion of menu
   char huge  *sltext ;                           // Help text for statusline
   tmenuitem  huge *itemfirst ;                         // First item in link
   tmenuitem  huge *itemlast ;                           // Last item in link
   int        itemcount ;                          // Number of items in menu
   int        itemmaxwidth ;                        // Max width of the items
   int        itemlasthot ;                    // Last selected item (hotkey)
   tmenu huge *nextmenu ;                                // Next menu in link
   tmenu huge *previousmenu ;                        // Previous menu in link
} ;


// ---- Class Declarations --------------------------------------------------

class tmenubar
{
   int  menubackcolor ;                           // Menubar background color
   int  menuforecolor ;                           // Menubar foreground color
   int  menuhighcolor ;                            // Menubar highlight color
   int  menucursorcolor ;                      // Menubar selection bar color
   int  menucount ;                             // Number of menus on menubar
   int  menubarwidth ;                          // Width of all created menus
   int  menulasthot ;                          // Last menu selected (hotkey)
   char        huge *menuhelp ;               // Ptr to help text for menubar
   tmenu       huge *menufirst ;                        // First menu in link
   tmenu       huge *menulast ;                          // Last menu in link
   tstatusline huge *menuslptr ;              // Ptr to the statusline object

   int  screenheight ;                                         // Screen size
   int  screenwidth ;                                          // Screen size

   public:

        far tmenubar () ;                                      // Constructor
        far ~tmenubar () ;                                      // Destructor

   void far setcolors                                   // Set menubar colors
      ( int back=LIGHTGRAY,                               // Background color
        int fore=BLACK,                                   // Foreground color
        int high=RED,                                      // Highlight color
        int cursor=GREEN,                                     // Cursor color
        int clockback=RED,                                     // Clock color
        int clockfore=WHITE ) ;
   void far sethelp                               // Set help ptr for menubar
      ( char huge *helptext ) ;      // Ptr to help text while in the menubar
   void far setslptr                                 // Set ptr to statusline
      ( tstatusline huge *slptr ) ;      // Ptr to an instantiated statusline
   void far addmenu                                            // Create menu
      ( char huge *name,                                      // Name of menu
        int       hotkey,                       // Key to activate menu (A-Z)
        char huge *sltext=NULL ) ;           // Statusline text for this menu
   void far additem                                            // Create item
      ( char huge *text="",                                      // Item text
        int       hotkey=0,                   // Item hotkey ('A' to 'Z' & 0)
        int       returnval=0,                // Return value of this command
        char huge *sltext=NULL ) ;                    // Item statusline text
   int  far trough                                        // Activate menubar
      ( int key ) ;                       // Key value to pass trough menubar
   void far itemsetavail                   // Set item availability ON or OFF
      ( int menuhotkey,                     // Hotkey of menu in wich item is
        int itemhotkey,                         // Hotkey of menu item to set
        int state=TRUE ) ;           // TRUE: available  FALSE: Not available
   void far refresh () ;                                // Redraw the menubar

   private:

   void far menudraw                         // Display 1 menuname on menubar
      ( int hotkey=0,                               // Hotkey of menu to draw
        int cursorflag=0 ) ;                   // 1: Display cursor  0: Don't
   int  far exttoascii                    // Convert 'ALT-letter' to 'letter'
      ( int code ) ;                                       // Code to convert
   tmenu huge* far menuexist              // Check if menu exist. Return addr
      ( int menuhotkey ) ;                          // Hotkey of menu to find
   tmenuitem huge* far itemexist                  // Return item addr or NULL
      ( int menuhotkey,                              // Menu in which to look
        int itemhotkey ) ;                                // Item to look for
   int  far chooseitem () ;                     // Opens menu and choose item
   void far itemdraw                              // Display 1 item in a menu
      ( twindow   huge *winptr,                         // Ptr to menu window
        tmenuitem huge *itemptr,                    // Ptr to item to display
        int            cursorflag=0 ) ;        // 0: Cursor off  1: Cursor on
} ;


// ---- End Header File ----------------------------------------------------

#endif
