#if !defined (SCREEN)                     // To prevent multiple declarations
#define SCREEN

// ---- Library Header Files ------------------------------------------------

#include <conio.h>
#include <stdio.h>


// ---- Typedefs ------------------------------------------------------------

struct cur_info
{
   unsigned char attribute ;                                // Text attribute
   unsigned char curx ;                     // X coordinate in current window
   unsigned char cury ;                     // Y coordinate in current window
   unsigned int  curtype ;                                    // Cursor shape
} ;


// ---- Prototypes ----------------------------------------------------------

void far savevideo               // Save all video informations except cursor

( text_info huge *ti,                            // Ptr to a text_info struct
  char huge*huge *savedscr=NULL                     // Ptr to a huge char ptr
) ;


void far restorevideo         // Restore all video informations except cursor

( text_info huge *ti,                            // Ptr to a text_info struct
  char huge*huge *savedscr=NULL                     // Ptr to a huge char ptr
) ;


void far savecursor                             // Save all cursor attributes

( cur_info huge *ci ) ;                           // Ptr to a cur_info struct


void far restorecursor                       // Restore all cursor attributes

( cur_info huge *ci ) ;                           // Ptr to a cur_info struct


// ---- End Header File -----------------------------------------------------

#endif
