/* KEYS.H:  Local definition
of keys for IBM PC/XT/AT family

Rev 89/10/18, R. Nagy
*/
#ifndef _KEYS

#define _KEYS 1

#define F1        0x3b
#define F2        0x3c
#define F3        0x3d
#define F4        0x3e
#define F5        0x3f
#define F6        0x40
#define F7        0x41
#define F8        0x42
#define F9        0x43
#define F10       0x44
#define F11       0x98
#define F12       0x99

#define SHIFT_F1  0x54
#define SHIFT_F2  0x55
#define SHIFT_F3  0x56
#define SHIFT_F4  0x57
#define SHIFT_F5  0x58
#define SHIFT_F6  0x59
#define SHIFT_F7  0x5a
#define SHIFT_F8  0x5b
#define SHIFT_F9  0x5c
#define SHIFT_F10 0x5d
#define SHIFT_F11 0xa2
#define SHIFT_F12 0xa3
#define SHIFT_I   0x0f

#define ALT_F1    0x68
#define ALT_F2    0x69
#define ALT_F3    0x6a
#define ALT_F4    0x6b
#define ALT_F5    0x6c
#define ALT_F6    0x6d
#define ALT_F7    0x6e
#define ALT_F8    0x6f
#define ALT_F9    0x70
#define ALT_F10   0x71
#define ALT_F11   0xb6
#define ALT_F12   0xb7

#define CTRL_F1   0x5e
#define CTRL_F2   0x5f
#define CTRL_F3   0x60
#define CTRL_F4   0x61
#define CTRL_F5   0x62
#define CTRL_F6   0x63
#define CTRL_F7   0x64
#define CTRL_F8   0x65
#define CTRL_F9   0x66
#define CTRL_F10  0x67
#define CTRL_F11  0xac
#define CTRL_F12  0xad

#define UP        0x48
#define DOWN      0x50
#define PGUP      0x49
#define PGDN      0x51
#define LEFT      0x4b
#define RIGHT     0x4d
#define HOME      0x47
#define END       0x4f
#define DEL       0x53
#define INS       0x52

/* Non-scan code keys,
flagged as NULL scan-codes.
(Makes a CP/M'er feel at home!)
*/
#define CTRL_H    0x08
#define CTRL_M    0x0d
#define CTRL_J    0x0a
#define CTRL_L    0x0c
#define CTRL_C    0x03
#define CTRL_I    0x09
#define CR        CTRL_M
#define LF        CTRL_J
#define TAB       CTRL_I
#define ESC       0x1B
#define PLUS      '+'
#define MINUS     '-'

#endif
