//BEGIN: "inevent.h"

// Only want to include it once.
#ifndef _INEVENT_H
#define _INEVENT_H

#define TRUE    1
#define FALSE   0

typedef char BOOL;

typedef struct tagPOINT {
   int x;
   int y;
} POINT;



// The four types, returned by GETMESSAGE
// (TYPE field in the message-structure)
#define MSG_MOUSE        910
#define MSG_KEY          940
#define MSG_KEY_CONTROL  941
#define MSG_ERROR        999

// "Msg" types for Type = MSG_MOUSE;
// (MESSAGE field in the message-structure)
#define MSG_MOUSE_LEFT_CLICK       MSG_MOUSE + 1
#define MSG_MOUSE_RIGHT_CLICK      MSG_MOUSE + 4

typedef struct tagDOSMSG {
   int     Type;   // See "types" (above)
   int     Msg;    // KEYS.H if key, else mouse-id
   POINT pt;       // ALWAYS know where it is.
} DOSMSG;

class Event {

   public:

      DOSMSG DosMsg;

		// Class overhead and management;
      Event();      // Class constructor
      ~Event();     // Class destructor

		// Mouse-specific functions;
      BOOL    HasMouse();
      POINT   WhereMouseXY();
		BOOL    SetMouseXY(int, int);

		// Keyboard-specific functions;
      int     WhereX();
      int     WhereY();
      POINT   WhereXY();
      BOOL    GotoXY(int, int);

		// Message retreval;
      DOSMSG  *GetMessage(char *, int);
      DOSMSG  *GetMessage(BOOL);

		// Miscellaneous functions;
      void    BellAlert(BOOL);

   private:
      int     C1X;   // Keyboard cursor (cursor #1)
      int     C1Y;   // ibid.
      int     C2X;   // Mouse cursor (cursor #2)
      int     C2Y;   // ibid.
      int     BUTTON;     // 'L', 'R', NULL code
      int     CTRLKEY;    // 2nd value of scan code
      int     bx, cx, dx; // used for register calls

      BOOL    bMouseOn;   // TRUE = Mouse Installed
      BOOL    bBellOn;    // BEEP on error
      int     GetEvent();
      // inline 4speed;
      int     _mouse(int, int *, int *, int *);
      int     MouseStatus();
      // Ret FALSE (0) if no mouse
      BOOL    MouseReset();

      // Only used for graphics mode.
      void    install_cursor_image(void);
};


//END  : "inevent.h"

#endif
