#include	<stdio.h>
#include	"evalx.h"	/* Must be included error constants */

double evalx(char *ptr);	/* declare evalx() */

extern	int	errorflg;	/* declare external errorflg */

main(int argc, char **argv)
{
	double val;		/* declare double for result */
	int	exitflg = 0;
	char	str[80];	/* storage for expression string */

	while(1)
	{
		/*
		 * If expression was in command argument then
		 * Compute, print, then quit.
		 * Else, wait for an input to be typed, compute,
		 * print, then wait again.
		 */
		if(argc > 1)
		{
			strcpy(str, argv[1]);
			exitflg++;
		}
		else
		{
			printf("Input expression:\n");
			gets(str);
		}
		val = evalx(str);	/* Evaluate the expression */

		/* Test error condition if any */
		switch(errorflg)
		{
		case 0:	/* NO ERROR, PRINT RESULT */
			printf("Result=%g\n", val);
			if(exitflg)
			{
				exit(0);
			}
			break;
		case	ERRFATAL:
			printf("Fatal error\n");
			break;
		case	ERRSYNTAX:
			printf("Syntax error\n");
			break;
		case	ERROVFLOW:
			printf("Overflow error\n");
			break;
		case	ERRSQRT:
			printf("Square root of neg number error\n");
			break;
		case	ERRFACT:
			printf("Factorial error\n");
			break;
		case	ERRFUNC:
			printf("Unknown math function error\n");
			break;
		case	ERRILLVAR:
			printf("Illegal variable error\n");
			break;
		default:
			break;
		}
	}
}
