/****************************************************************************/
/* COM_DEMO.C 																															*/
/*																																					*/
/*       This demo shows the use of most of EnCom's functions and can       */
/*       be compiled in small model using the EnCom library and EnQue's     */
/*       UltraWin text window library, also available on most online        */
/*       services and our 24 hour BBS. (1-816-353-0991   2400,N,8,1)        */
/*																													 EnQue Software */
/****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "uw.h"
#include "uw_globx.h"
#include "uw_keys.h"
#include "encom.h"

#define QUE_SIZE 2048

void wn_ch_ctrl(char c, WINDOW *wnp );
void test_output(WINDOW *wnp, PORT *cp);
void disp_rx_stats( WINDOW *wnp, PORT *cp );
void disp_tx_stats( WINDOW *wnp, PORT *cp );
void disp_232_stats( WINDOW *wnp, PORT *cp );
void disp_232_stats2( WINDOW *wnp, PORT *cp );
void disp_232_stats3( int mask, WINDOW *wnp );
void get_baud(WINDOW *wnp, PORT *cp);
void get_water(WINDOW *wnp, PORT *cp);
void performance_test(WINDOW *wnp, PORT *cp);
void gets_test(WINDOW *wnp, PORT *cp);
void test_crc(WINDOW *wnp, PORT *cp);
void test_modem_cmd( WINDOW *wnp, PORT *cp );
void display_help();
void dump_regs( WINDOW *wnp, PORT *cp );

PORT Port;
WINDOW Stat_wn, Tx_wn, Tx_stat_wn, Rx_wn, Rx_stat_wn;
extern ulong Interrupts, Bad_irqs;
char *Uart_strs[4] = { "No Uart", "8250", "16450", "16550" };
char *Rts_strs[3]  = { "RTS/CTS  OFF", "RTS/CTS  ON ", "RTS/CTS  HS " };

/*********/
/* ~main */
/*       ********************************************************************/
/****************************************************************************/
main( int argc, char *argv[] )
{
	int port = COM1;
	long baud = 2400L;
	int c, end_flag = 0, val;
	int dtr = 1, rts = 1, out1 = 0, out2 = 1, loop = 0;

	if( argc >= 2 )
	{
		switch(argv[1][0])
		{
			case '1': port = COM1; break;
			case '2': port = COM2; break;
			case '3': port = COM3; break;
			case '4': port = COM4; break;
		}
	}
	if( argc >= 3 )
		baud = atol(argv[2]);

	init_video(80, 25);
	init_clock(0x3333);

	wn_create( 0, 0, V_cols-1, V_rows-1, NO_BDR, WN_NORMAL, &Stat_wn );
	wn_color( YELLOW, BLACK, &Stat_wn );
	add_window(&Stat_wn);

	wn_create( 0, 0, V_cols-24, V_rows/2-3, SGL_BDR, WN_NORMAL, &Tx_wn );
	wn_color( YELLOW, BLUE, &Tx_wn );
	wn_bdr_color( YELLOW, BLUE, &Tx_wn );
	wn_name("Transmit Window", &Tx_wn);
	add_window(&Tx_wn);
	wn_init_tabs(8,&Tx_wn);
	Tx_wn.cr_lf = 1;
	Tx_wn.eol_wrap = 1;

	wn_create( V_cols-22, 0, V_cols, V_rows/2-2, NO_BDR, WN_NORMAL, &Tx_stat_wn );
	wn_color( YELLOW, BLACK, &Tx_stat_wn );
	add_window(&Tx_stat_wn);

	wn_create( 0, V_rows/2, V_cols-24, V_rows-3, SGL_BDR, WN_NORMAL, &Rx_wn );
	wn_color( YELLOW, RED, &Rx_wn );
	wn_bdr_color( YELLOW, RED, &Rx_wn );
	wn_name("Receive Window", &Rx_wn);
	add_window(&Rx_wn);
	wn_init_tabs(8,&Rx_wn);
	Rx_wn.cr_lf = 1;
	Rx_wn.eol_wrap = 1;

	wn_create( V_cols-22, V_rows/2, V_cols, V_rows-3, NO_BDR, WN_NORMAL, &Rx_stat_wn );
	wn_color( RED, BLACK, &Rx_stat_wn );
	add_window(&Rx_stat_wn);

	if( (val = com_port_create(port, baud,'N',8,1,QUE_SIZE,QUE_SIZE,&Port)) < 0)
	{
		wn_printf(&Tx_wn, "Cannot create com port - error %d", val);
		get_key();
		goto end1;
	}
	com_232_ctrl(ON, DTR | RTS | OUT2, &Port);
	disp_232_stats(&Stat_wn, &Port);
	wn_plst( 0, 11, "Press Alt-H for help", &Stat_wn );
	mv_cs( 30, 11, &Stat_wn );
	wn_printf(&Stat_wn, "Lowwater:%5d  Highwater%5d",
		get_lowwater(&Port), get_highwater(&Port) );

	wn_plst(0,6, loop               ? "LOOPBACK ON " : "LOOPBACK OFF", &Tx_stat_wn);
	wn_plst(0,7, Rts_strs[is_cts_flow(&Port)], &Tx_stat_wn);
	wn_plst(0,8, is_xon_flow(&Port) ? "XON/XOFF ON " : "XON/XOFF OFF", &Tx_stat_wn);
	wn_plst(0,9, is_dcd_flow(&Port) ? "DCD      ON " : "DCD      OFF", &Tx_stat_wn);
	wn_plst(0,10,is_dsr_flow(&Port) ? "DSR      ON " : "DSR      OFF", &Tx_stat_wn);

	while( !end_flag )
	{
		while( (c = com_getc(&Port)) != -1 )
		{
			wn_ch_ctrl((char) c, &Rx_wn);
			if( is_que_status(&Port) )
			{
				wn_ch(c>>8,&Rx_wn);
				disp_232_stats3(c>>8,&Stat_wn);
			}
		}
		if( check_key() )
		{
			switch(c = get_key())
			{
				case KEY_ESC: end_flag = 1; break;
				case KEY_ALT_H: display_help(); break;

/*-------------------------- regular function keys -------------------------*/
				case KEY_F1:
					dtr = !dtr;
					com_232_ctrl(dtr, DTR, &Port);
					disp_232_stats(&Stat_wn, &Port);
					break;
				case KEY_F2:
					rts = !rts;
					com_232_ctrl(rts, RTS, &Port);
					disp_232_stats(&Stat_wn, &Port);
					break;
				case KEY_F3:
					out1 = !out1;
					com_232_ctrl(out1, OUT1, &Port);
					disp_232_stats(&Stat_wn, &Port);
					break;
				case KEY_F4:
					if( is_loop(&Port) )						/* don't change if not loopback */
					{
						out2 = !out2;
						com_232_ctrl(out2, OUT2, &Port);
						disp_232_stats(&Stat_wn, &Port);
					}
					break;

				case KEY_F5:
					loop = !loop;
					com_232_ctrl(loop, LOOP, &Port);
					disp_232_stats(&Stat_wn, &Port);
					wn_plst(0,6, loop ? "LOOPBACK ON " : "LOOPBACK OFF", &Tx_stat_wn);
					break;

				case KEY_F6:
					if( is_cts_flow(&Port) == HS_RTS_CTS )
						set_cts_flow(OFF, &Port);
					else if( is_cts_flow(&Port) == OFF )
						set_cts_flow(ON, &Port);
					else
						set_cts_flow(HS_RTS_CTS, &Port);
					wn_plst(0,7, Rts_strs[is_cts_flow(&Port)], &Tx_stat_wn);
					break;
				case KEY_F7:
					if( is_xon_flow(&Port) )
						set_xon_flow(OFF, XON_ANY, XOFF_CHAR, 1800, 200, &Port);
					else
						set_xon_flow(ON, XON_ANY, XOFF_CHAR, 1800, 200, &Port);
					wn_plst(0,8, is_xon_flow(&Port) ? "XON/XOFF ON " : "XON/XOFF OFF", &Tx_stat_wn);
					break;

				case KEY_F8:
					mv_cs( 0,11,&Stat_wn),	wn_cleol(&Stat_wn);
					if( is_que_status(&Port) )
					{
						set_que_status(OFF, &Port);
						wn_plst( 0, 11, "Press Alt-H for help", &Stat_wn );
						mv_cs( 30, 11, &Stat_wn );
						wn_printf(&Stat_wn, "Lowwater:%5d  Highwater%5d",
							get_lowwater(&Port), get_highwater(&Port) );
					}else
						set_que_status(ON, &Port);
					break;

				case KEY_F9:
					send_break(Tics_per_sec/4,&Port);
					break;

				case KEY_F10:
					test_crc(&Tx_wn, &Port);
					break;

/*------------------------- alternate function keys ------------------------*/
				case KEY_ALT_F1:
					test_modem_cmd(&Tx_wn, &Port);
					break;

				case KEY_ALT_F2:
					wn_clear(&Tx_wn);
					wn_plst(0,0,"Initializing modem...", &Tx_wn);
					wn_st(modem_reset(&Port), &Tx_wn);
					modem_echo(OFF,&Port);
					wn_st("done!", &Tx_wn);
					wn_plst(0,1,"Dialing EnQue BBS...", &Tx_wn);
					wn_st(modem_dial("ATDT13530991",&Port),&Tx_wn);
					wn_st("done!", &Tx_wn);

					break;
				case KEY_ALT_F3:
					wn_plst(0,2,"Hanging up phone...", &Tx_wn);
					wn_st(modem_hangup(&Port), &Tx_wn);
					break;

				case KEY_ALT_F4:
					com_clear_que( RX, &Port);
					break;
				case KEY_ALT_F5:
					com_clear_que( TX, &Port);
					break;
				case KEY_ALT_F6:
					performance_test( &Tx_wn, &Port);
					break;

				case KEY_ALT_F7:
					dump_regs( &Tx_wn, &Port);
					break;

				case KEY_ALT_F8:
					prime_tx(&Port);
					break;
				case KEY_ALT_F9:
					force_tx(0x55,&Port);
					break;
				case KEY_ALT_F10:
					Port.edge_trigger = !Port.edge_trigger;
					break;

/*--------------------------- control function keys ------------------------*/
				case KEY_CTRL_F1:
					if( is_dcd_flow(&Port) )
						set_dcd_flow(OFF, &Port);
					else
						set_dcd_flow(ON, &Port);
					wn_plst(0,9, is_dcd_flow(&Port) ? "DCD      ON " : "DCD      OFF", &Tx_stat_wn);
					break;
				case KEY_CTRL_F2:
					if( is_dsr_flow(&Port) )
						set_dsr_flow(OFF, &Port);
					else
						set_dsr_flow(ON, &Port);
					wn_plst(0,10,is_dsr_flow(&Port) ? "DSR      ON " : "DSR      OFF", &Tx_stat_wn);
					break;


				case KEY_CTRL_F3:
					com_clear_que(TX | RX, &Port);
					Port.tx_chars = Port.rx_chars = 0;
					Port.parity_errs = Port.framing_errs = Port.overrun_errs = 0;
					Port.break_cnt = Port.msg_cnt = Port.tx_overflow = Port.rx_overflow = 0;
					Interrupts = Bad_irqs = 0;
					break;

				case KEY_CTRL_F4:
					get_baud(&Tx_wn, &Port);
					break;

				case KEY_CTRL_F5:
					fifo_rx_reset(&Port);
					fifo_tx_reset(&Port);
					if( Port.uart_type == ID_16550 )
					{
						if( is_fifo_enabled(&Port) )
							fifo_disable(&Port);
						else
							fifo_enable(&Port);
					}
					break;
				case KEY_CTRL_F6:
					com_fifo_trigger(RX_TRIG_1,&Port);
					break;
				case KEY_CTRL_F7:
					com_fifo_trigger(RX_TRIG_4,&Port);
					break;
				case KEY_CTRL_F8:
					com_fifo_trigger(RX_TRIG_8,&Port);
					break;
				case KEY_CTRL_F9:
					com_fifo_trigger(RX_TRIG_14,&Port);
					break;
				case KEY_CTRL_F10:
					get_water(&Tx_wn,&Port);
					mv_cs( 30, 11, &Stat_wn );
					wn_printf(&Stat_wn, "Lowwater:%5d  Highwater%5d",
						get_lowwater(&Port), get_highwater(&Port) );
					break;

				default:
					wn_ch_ctrl((char) c, &Tx_wn);
					if( com_putc(c, &Port) == -1 )
						wn_plst(40,10,"put error",&Tx_wn);
					break;
			}
		}else{
			disp_rx_stats(&Rx_stat_wn, &Port);
			disp_tx_stats(&Tx_stat_wn, &Port);
			disp_232_stats2(&Stat_wn, &Port);
			mv_cs(0,10,&Stat_wn), wn_printf(&Stat_wn, "Port:%d Uart:%s Baud:%-6ld [%d]",
				Port.chan + 1, Uart_strs[Port.uart_type], Port.baud, Port.edge_trigger);
			if( Port.uart_type == ID_16550 )
				wn_printf(&Stat_wn, "FIFO:%s  TRIGGER:%2d",
					is_fifo_enabled(&Port) ? "ON " : "OFF", get_trigger_level(&Port));
		}
	}
	com_port_destroy(&Port);
end1:
	remove_window(&Stat_wn);
	remove_window(&Tx_wn);
	remove_window(&Tx_stat_wn);
	remove_window(&Rx_wn);
	remove_window(&Rx_stat_wn);
	end_clock();
	end_video();
	return(1);
}
/*** end of main ***/

/***************/
/* ~wn_ch_ctrl */
/*             ***************************************************************/
/*****************************************************************************/
void wn_ch_ctrl(char c, WINDOW *wnp )
{
	switch( c )
	{
		case 0x07: tone(1024,10);       break;
		case '\r': wnp->csr_x = 0;      if( !wnp->cr_lf ) break;
		case '\n': wn_csr_dn(1,wnp);	  break;
		case '\t': wn_tab_right(1,wnp); break;
		case '\b': wn_csr_left(1,wnp), wn_ch(' ', wnp), wn_csr_left(1,wnp); break;
		default  : wn_ch(c, wnp);       break;
	}
}
/*** end of wn_ch_ctrl ***/


/******************/
/* ~disp_rx_stats */
/*                ************************************************************/
/*****************************************************************************/
void disp_rx_stats( WINDOW *wnp, PORT *cp )
{
	mv_cs(0,0,wnp),	wn_printf(wnp, "Rx chars:%8lu", cp->rx_chars    );
	mv_cs(0,1,wnp),	wn_printf(wnp, "Rx read :%8u",  cp->rx_read     );
	mv_cs(0,2,wnp),	wn_printf(wnp, "Rx write:%8u",  cp->rx_write    );
	mv_cs(0,3,wnp),	wn_printf(wnp, "Rx cnt  :%8u",  cp->rx_cnt      );
	mv_cs(0,4,wnp),	wn_printf(wnp, "Rx oflow:%8u",  cp->rx_overflow );
	mv_cs(0,5,wnp),	wn_printf(wnp, "Parity  :%8u",  cp->parity_errs );
	mv_cs(0,6,wnp),	wn_printf(wnp, "Framing :%8u",  cp->framing_errs);
	mv_cs(0,7,wnp),	wn_printf(wnp, "Overrun :%8u",  cp->overrun_errs);
	mv_cs(0,8,wnp),	wn_printf(wnp, "Breaks  :%8u",  cp->break_cnt   );
	mv_cs(0,9,wnp),	wn_printf(wnp, "Msg Cnt :%8u",  cp->msg_cnt     );
	mv_cs(0,10,wnp),wn_printf(wnp, "Bad Irqs:%8lu", Bad_irqs        );
}
/*** end of disp_rx_stats ***/

/******************/
/* ~disp_tx_stats */
/*                ************************************************************/
/*****************************************************************************/
void disp_tx_stats( WINDOW *wnp, PORT *cp )
{
	mv_cs(0,0,wnp),	wn_printf(wnp, "Tx chars:%8lu", cp->tx_chars);
	mv_cs(0,1,wnp),	wn_printf(wnp, "Tx read :%8u",  cp->tx_read );
	mv_cs(0,2,wnp),	wn_printf(wnp, "Tx write:%8u",  cp->tx_write);
	mv_cs(0,3,wnp),	wn_printf(wnp, "Tx cnt  :%8u",  cp->tx_cnt  );
	mv_cs(0,4,wnp),	wn_printf(wnp, "Tx on   :%8u",  cp->tx_on   );
	mv_cs(0,5,wnp),	wn_printf(wnp, "Irqs    :%8lu",  Interrupts  );
}
/*** end of disp_rx_stats ***/

/*******************/
/* ~disp_232_stats */
/*                 ***********************************************************/
/*****************************************************************************/
void disp_232_stats( WINDOW *wnp, PORT *cp )
{
	wn_plst( 0, 23, is_dtr(cp)  ? "DTR : 1" : "DTR : 0", wnp );
	wn_plst(10, 23, is_rts(cp)  ? "RTS : 1" : "RTS : 0", wnp );
	wn_plst(20, 23, is_out1(cp) ? "OUT1: 1" : "OUT1: 0", wnp );
	wn_plst(30, 23, is_out2(cp) ? "OUT2: 1" : "OUT2: 0", wnp );
}
/*** end of disp_232_stats ***/

/********************/
/* ~disp_232_stats2 */
/*                  **********************************************************/
/*****************************************************************************/
void disp_232_stats2( WINDOW *wnp, PORT *cp )
{
	wn_plst(40, 23, is_dsr(cp)  ? "DSR : 1" : "DSR : 0", wnp );
	wn_plst(50, 23, is_cts(cp)  ? "CTS : 1" : "CTS : 0", wnp );
	wn_plst(60, 23, is_dcd(cp)  ? "DCD : 1" : "DCD : 0", wnp );
	wn_plst(70, 23, is_ri(cp)   ? "RI  : 1" : "RI  : 0", wnp );

	wn_plst(78, 23, cp->rx_xstate ? "1" : "0", wnp );
	wn_plst(79, 23, cp->tx_xstate ? "1" : "0", wnp );
}
/*** end of disp_232_stats2 ***/

/********************/
/* ~disp_232_stats3 */
/*                  **********************************************************/
/*****************************************************************************/
void disp_232_stats3( int mask, WINDOW *wnp )
{
	mv_cs( 0,11,wnp),	wn_printf(wnp, "Parity :%1d", mask & (PE >> 1));
	mv_cs(10,11,wnp),	wn_printf(wnp, "Framing:%1d", mask & (FE >> 1));
	mv_cs(20,11,wnp),	wn_printf(wnp, "Overrun:%1d", mask & (OE >> 1));
	mv_cs(30,11,wnp),	wn_printf(wnp, "Break  :%1d", mask & (BI >> 1));
	wn_plst(40, 11, (mask & DSR) ? "DSR : 1" : "DSR : 0", wnp );
	wn_plst(50, 11, (mask & CTS) ? "CTS : 1" : "CTS : 0", wnp );
	wn_plst(60, 11, (mask & DCD) ? "DCD : 1" : "DCD : 0", wnp );
	wn_plst(70, 11, (mask & RI ) ? "RI  : 1" : "RI  : 0", wnp );
}
/*** end of disp_232_stats3 ***/

/*************/
/* ~get_baud */
/*           ****************************************************************/
/****************************************************************************/
void get_baud(WINDOW *wnp, PORT *cp)
{
	char msg[8];
	long baud;

	setmem(msg,8,0);
	wn_clear(wnp);
	mv_cs( 0, 4, wnp );
	wn_printf(wnp, "Please enter new baud rate (1-115000):" );
	wn_gets(msg, "______", "######", wnp->att, STRIP_ON, wnp);
	baud = atol(msg);
	if( range(1,baud,115000L) )
		com_port_init(baud, 'N', 8, 1, cp);
	wn_clear(wnp);
}
/*** end of get_baud ***/

/**************/
/* ~get_water */
/*            ***************************************************************/
/****************************************************************************/
void get_water(WINDOW *wnp, PORT *cp)
{
	char  msg[8];
	uint  lowwater, highwater;

	setmem(msg,8,0);
	wn_clear(wnp);
	mv_cs( 0, 4, wnp );
	wn_printf(wnp, "Please enter new lowwater mark (10-2000):" );
	wn_gets(msg, "____", "####", wnp->att, STRIP_ON, wnp);
	lowwater = atoi(msg);
	if( range(10,lowwater,2000) )
		set_lowwater(lowwater, cp);

	mv_cs( 0, 6, wnp );
	wn_printf(wnp, "Please enter new highwater mark (10-2000):" );
	wn_gets(msg, "____", "####", wnp->att, STRIP_ON, wnp);
	highwater = atoi(msg);
	if( range(lowwater + 1,highwater,2000) )
		set_highwater(highwater, cp);
	wn_clear(wnp);
}
/*** end of get_water ***/

/*************/
/* ~test_crc */
/*           ****************************************************************/
/****************************************************************************/
void test_crc(WINDOW *wnp, PORT *cp)
{
	char  msg[129], fmt[129], defmt[129], tmp[129], mask[129];
	uint  i, len, r = 0;

	setmem(msg,128,0);
	setmem(tmp,32,'*'), tmp[32] = '\0';
	setmem(mask,32,'_'), mask[32] = '\0';

#ifdef __cplusplus
	mk_crc_tbl( 0xffff, CRCCITT_REV, (ushort (*)(...)) gen_crc_rev );
#else
	mk_crc_tbl( 0xffff, CRCCITT_REV, gen_crc_rev );
#endif

	set_encrypt(0x12, cp);
	set_match(0x03, cp);
	init_msg(cp);									/* tells msg formatting routines about above*/

	mv_cs( 0, r++, wnp );
	wn_printf(wnp, "Please type some characters, <Enter> when finished");
	mv_cs( 0, r++, wnp );
	wn_gets(msg, mask, tmp, wnp->att, STRIP_ON, wnp);

	len = fmt_msg( (uchar *) msg, (uchar *) fmt, strlen(msg));
	mv_cs( 0, r++, wnp );
	wn_printf(wnp, "Your quoted, encrypted and CRC'd message:");
	mv_cs( 0, r++, wnp );
	for (i=0; i<len; i++)
		wn_ch(fmt[i],wnp);

	len = defmt_msg((uchar *) fmt, (uchar *) defmt);

	mv_cs( 0, r++, wnp );
	wn_printf(wnp, "And back to normal:");
	mv_cs( 0, r++, wnp );
	for (i=0; i<len; i++)
		wn_ch(defmt[i], wnp);
	get_key();
	wn_clear(wnp);
}
/*** end of test_crc ***/

/*******************/
/* ~test_modem_cmd */
/*                 **********************************************************/
/****************************************************************************/
void test_modem_cmd( WINDOW *wnp, PORT *cp )
{
	int 	r = 0;
	char  msg[129], tmp[129], mask[129];

	wn_clear(wnp);
	setmem(msg,128,0);
	setmem(tmp,32,'*'), tmp[32] = '\0';
	setmem(mask,32,'_'), mask[32] = '\0';
	mv_cs( 0, r++, wnp );
	wn_printf(wnp, "Please type a modem string, <Enter> when finished");
	mv_cs( 0, r++, wnp );
	wn_gets(msg, mask, tmp, wnp->att, STRIP_ON, wnp);
	wn_plst(0, r++, "Reply:", wnp );
	wn_st(modem_cmd(msg,-1,5,cp), wnp);
}
/*** test_modem_cmd ***/

/*********************/
/* ~performance_test */
/*                   *********************************************************/
/*****************************************************************************/
uchar Tmp_tx[QUE_SIZE];
void performance_test(WINDOW *wnp, PORT *cp)
{
	int i, end_flag, r;
	long loops, save_loops;

	wn_clear(wnp);
	for( i = 0; i < 1024; i++ )
		Tmp_tx[i] = (uchar) (i % ('~'-' ')) + ' ';
	com_irq_ctrl(OFF, DR_IRQ | THRE_IRQ | RLS_IRQ | MS_IRQ, cp);
	com_irq_ctrl(ON,  MS_IRQ, cp);
	wn_plst( CENTERED, 0, "<Hit any key to abort test>", wnp );
	wn_plst( CENTERED, 1, "-- This tests performance using transmit interrupts --", wnp );
	for( i = 0; i < 2 && !check_key(); i++ )
	{
		r = 2;
		end_flag = 0;
		loops = 0;
		if( !i )
			wn_plst( 0, r++, "Analyzing system speed - please wait 10 seconds...", wnp );
		else
			wn_plst( 0, r++, "Transmitting test data - please wait 10 seconds...", wnp );
		cp->tx_chars = 0;
		Uw_timers[3] = 0;
		while( (end_flag <= 10) && !check_key() )				/* loop for 10 seconds	*/
		{
			if( !Uw_timers[3] )           								/* display stats 1/sec  */
			{
				disp_tx_stats(&Tx_stat_wn,cp);
				Uw_timers[3] = Tics_per_sec;
				end_flag++;																	/* bump one a second		*/
			}
			if( i )
				if( com_tx_free(cp) > 1000 )
				{
					disable();
					com_putc_qty( Tmp_tx, 1000, cp );					/* send 1000 bytes 			*/
					enable();
				}
			loops++;
		}
		com_clear_que(TX,cp);
		if( !i )																				/* save loop overhead   */
		{
			save_loops = loops;
			cp->tx_chars = 0;
		}
	}
/*------------------------- analyze statistics -----------------------------*/
	if( !check_key() )
	{
		r = 0;
		wn_clear(wnp);
		mv_cs(0,r++,wnp);
		wn_printf(wnp, "At %ld bps, sent %ld chars in 10s (%d cps).",
			cp->baud, cp->tx_chars, (int) (cp->tx_chars / 10L) );
		mv_cs(0,r++,wnp);
		wn_printf(wnp, "This is %ld%% of ideal for this baud rate.",
			(cp->tx_chars * 100L) / cp->baud );
		mv_cs(0,r++,wnp);
		wn_printf(wnp, "CPU overhead was %ld%%.",
			100L - ((loops * 100L) / save_loops) );
		r++;
		wn_plst(0,r++,"These results have a slight error due to imperfect", wnp);
		wn_plst(0,r++,"timing characteristics of the PC.", wnp);
		r++;
		wn_plst(0,r++,"Feel free to repeat this test at different baud rates.",wnp);
	}else{
		get_key();
		wn_clear(wnp);
		wn_plst( CENTERED, 4, "Performance Test Aborted!", wnp );
	}
	com_irq_ctrl(ON, DR_IRQ | RLS_IRQ | MS_IRQ, cp);
}
/*** end of performance_test ***/

/*****************/
/* ~display_help */
/*               ************************************************************/
/****************************************************************************/
void display_help()
{
	int r = 0;
	WINDOW wn;

	wn_create( 0, 0, V_cols-1, V_rows-1, SGL_BDR, WN_NORMAL, &wn );
	wn_color( LIGHTGRAY, RED, &wn );
	add_window(&wn);

	wn_plst(0, r++, "F1 - Toggle DTR                          ", &wn);
	wn_plst(0, r++, "F2 - Toggle RTS                          ", &wn);
	wn_plst(0, r++, "F3 - Toggle OUT1                         ", &wn);
	wn_plst(0, r++, "F4 - Toggle OUT2                         ", &wn);
	wn_plst(0, r++, "F5 - Toggle LOOPBACK mode                ", &wn);
	wn_plst(0, r++, "F6 - Toggle RTS/CTS  Handshake mode      ", &wn);
	wn_plst(0, r++, "F7 - Toggle XON/XOFF Handshake mode      ", &wn);
	wn_plst(0, r++, "F8 - Toggle <queue status> mode          ", &wn);
	wn_plst(0, r++, "F9 - Send 1/4 second Break               ", &wn);
	wn_plst(0, r++, "F10- Test CRC/Msg formatting routines    ", &wn);
	r++;
	wn_plst(0, r++, "Alt F1 - Test modem commands             ", &wn);
	wn_plst(0, r++, "Alt F2 - Dial EnQue BBS                  ", &wn);
	wn_plst(0, r++, "Alt F3 - Hangup the phone                ", &wn);
	wn_plst(0, r++, "Alt F4 - Clear RX Queue                  ", &wn);
	wn_plst(0, r++, "Alt F5 - Clear TX Queue                  ", &wn);
	wn_plst(0, r++, "Alt F6 - Do Performance Test             ", &wn);
	wn_plst(0, r++, "Alt F7 - Dump Uart registers             ", &wn);
	wn_plst(0, r++, "Alt F8 - Kickstart transmitter           ", &wn);
	wn_plst(0, r++, "Alt F9 - Force transmission of hex 55    ", &wn);
	wn_plst(0, r++, "Alt F10- Toggle edge triggered interrupts", &wn);

	r = 0;
	wn_plst(40,r++, "Ctl F1 - toggle DCD handshaking ", &wn);
	wn_plst(40,r++, "Ctl F2 - toggle DSR handshaking ", &wn);
	wn_plst(40,r++, "Ctl F3 - Clear statistics ", &wn);
	wn_plst(40,r++, "Ctl F4 - Change baud rate ", &wn);
	wn_plst(40,r++, "Ctl F5 - Toggle 16550 FIFO mode ", &wn);
	wn_plst(40,r++, "Ctl F6 - Set 16550 FIFO trigger to 1 ", &wn);
	wn_plst(40,r++, "Ctl F7 - Set 16550 FIFO trigger to 4 ", &wn);
	wn_plst(40,r++, "Ctl F8 - Set 16550 FIFO trigger to 8 ", &wn);
	wn_plst(40,r++, "Ctl F10- Set low & highwater marks", &wn);

	get_key();

	remove_window(&wn);
}
/*** end of display_help ***/

/**************/
/* ~dump_regs */
/*            ***************************************************************/
/****************************************************************************/
void dump_regs( WINDOW *wnp, PORT *cp )
{
	int r = 0, fmt;

	mv_cs(0, r++, wnp); wn_printf(wnp, "IER :%04x", inbyte(cp->uart[IER]) );
	mv_cs(0, r++, wnp); wn_printf(wnp, "IIR :%04x", inbyte(cp->uart[IIR]) );
	mv_cs(0, r++, wnp); wn_printf(wnp, "LCR :%04x", fmt = inbyte(cp->uart[LCR]) );
	mv_cs(0, r++, wnp); wn_printf(wnp, "MCR :%04x", inbyte(cp->uart[MCR]) );
	mv_cs(0, r++, wnp); wn_printf(wnp, "LSR :%04x", inbyte(cp->uart[LSR]) );
	mv_cs(0, r++, wnp); wn_printf(wnp, "MSR :%04x", inbyte(cp->uart[MSR]) );
	outbyte(cp->uart[LCR], fmt | DLAB);
	mv_cs(0, r++, wnp); wn_printf(wnp, "DLL :%04x", inbyte(cp->uart[DLL]) );
	mv_cs(0, r++, wnp); wn_printf(wnp, "DLH :%04x", inbyte(cp->uart[DLH]) );
	outbyte(cp->uart[LCR], fmt);
}
/*** end of dump_regs ***/

/**** END OF FILE ****/
