;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_C.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   get_alt_context_size                                    ;
;                                                                             ;
;      DESCRIPTION:   This function returns the storage requirements for the  ;
;                     map hardware context save area referenced by the other  ;
;                     functions when you want to dynamically allocate this    ; 
;                     space.                                                  ;
;                                                                             ;
;           PASSED:   &context_size:                                          ;
;                        is a far pointer to the size of the map hardware     ;
;                        context save area size.                              ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     context_size:                                           ;
;                        is the number of bytes that will be transferred to   ;
;                        the memory area supplied by an operating system      ;
;                        whenever an operating system requests the            ;
;                        get_context or get_set_context functions.            ;
;                                                                             ;
;                        Normally, you just supply a CONTEXT_STRUCT structure ;
;                        which contains an array of the largest space         ;
;                        possible (currently 255 bytes).  If you want to      ;
;                        dynamically allocate exactly the amount of storage   ;
;                        required to save a context, use this function to get ;
;                        the size needed (see example below).  The size       ;
;                        depends on how the expanded memory system is         ;
;                        configured and how the expanded memory manager is    ;
;                        implemented.                                         ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int context_size;                              ;
;                     unsigned int alt_reg_set;                               ;
;                     void         *alt_context;                              ;
;                                                                             ;
;                     status = get_alt_context_size (&context_size);          ;
;                     if (status == PASSED)                                   ;
;                     {                                                       ;
;                        alt_context = malloc (context_size);                 ;
;                        if (context == NULL)                                 ;
;                           /* error condition (no memory to allocate) */     ;
;                        else                                                 ; 
;                        {                                                    ;
;                           status = set_alt_reg_set (alt_reg_set,            ;
;                                            (CONTEXT_STRUCT *) alt_context); ;
;                           if (status == PASSED)                             ;
;                              /* continue normal code */                     ;
;                           else                                              ;
;                              /* error condition */                          ;
;                        }                                                    ;
;                     }                                                       ;
;                     else                                                    ;
;                        /* error condition */                                ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_alt_context_size	PROC	                                              \
			ptr_alt_context_size:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the size of the current mapping context array;            ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_alt_map_save_array_size_fcn 
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the size of the current mapping context array back to    ;
	;   .   the caller;                                                   ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_alt_context_size
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_alt_context_size		ENDP

END
