;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM26_D.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   get_hw_info                                             ;
;                                                                             ;
;      DESCRIPTION:   This function returns an array containing expanded      ;
;                     memory hardware configuration information for use by an ;
;                     operating system/environment.                           ;
;                                                                             ;
;           PASSED:   &hw_info:                                               ;
;                        is a far pointer to a structure that the operating   ;
;                        system supplies where the memory manager will copy   ;
;                        expanded memory hardware information.                ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     hw_info: is a structure ...                             ;
;                        is a structure returned by the memory manager which  ;
;                        contains expanded memory hardware information.       ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        hw_info.raw_page_size_paragraphs:                    ;
;                           is the size of a raw mappable physical page in    ;
;                           paragraphs (16 bytes).  LIM standard pages are    ;
;                           always 16K bytes.  However, other implementations ;
;                           of expanded memory boards do not necessarily      ;
;                           comply with this standard and can emulate a       ;
;                           16K-byte page by mapping in multiple smaller      ;
;                           pages.  This member specifies the size of a       ;
;                           mappable physical page viewed from the hardware   ;
;                           implementation level.                             ;
;                                                                             ;
;                        hw_info.alt_reg_set_count:                           ;
;                           is the number of alternate mapping register sets. ;
;                           The additional mapping register sets are termed   ;
;                           alternate mapping register sets.                  ;
;                                                                             ;
;                           All expanded memory boards have at least one set  ;
;                           of hardware registers to perform the logical to   ;
;                           physical page mapping.  Some expanded memory      ;
;                           boards have more than one set of these mapping    ;
;                           registers.  This member specifies how many of     ;
;                           these alternate mapping register sets exist       ;
;                           (beyond the one set that all expanded memory      ;
;                           boards have) on the expanded memory boards in the ;
;                           system.  If an expanded memory card has only one  ;
;                           set of mapping registers (that is, no alternate   ;
;                           mapping register sets) this member has a value of ;
;                           zero.                                             ;
;                                                                             ;
;                        hw_info.context_size:                                ;
;                           is the number of bytes required for the array     ;
;                           required to save a mapping context.  The value    ;
;                           returned in this member is exactly the same as    ;
;                           that returned by the get_context_size function.   ;
;                                                                             ;
;                        hw_info.DMA_reg_set_count:                           ;
;                           is the number of register sets that can be        ;
;                           assigned to DMA channels.  These DMA register     ;
;                           sets, although similar in use to alternate        ;
;                           register sets, are for DMA mapping and not task   ;
;                           mapping.                                          ;
;                                                                             ;
;                           If the expanded memory hardware does not support  ;
;                           DMA register sets, care must be taken when DMA is ;
;                           taking place.  Essentially, DMA CANNOT take       ;
;                           place into an expanded memory page because a TSR  ;
;                           which uses expanded memory can be activated and   ;
;                           thus change the memory mapping context of the     ;
;                           region that DMA read/writes are occurring.        ;
;                                                                             ;
;                           In a multitasking operating system, when one task ;
;                           is waiting for DMA to complete, it is useful to   ;
;                           be able to switch to another task.  However, if   ;
;                           the DMA is taking place in memory that the second ;
;                           task will need to remap, remapping would be       ;
;                           disastrous.                                       ;
;                                                                             ;
;                           If the expanded memory hardware can detect when   ;
;                           DMA is occurring, the OS/E should allow task      ;
;                           switches and remapping during DMA.  If no special ;
;                           support for DMA is available, no remapping should ;
;                           be done when DMA is in progress.                  ;
;                                                                             ;
;                        hw_info.DMA_channel_operation:                       ;
;                           is a special operational case for the DMA         ;
;                           register sets.  A value of zero specifies that    ;
;                           the DMA register sets behave as described in      ;
;                           _DMA_reg_set functions.  A value of one specifies ;
;                           that the expanded memory hardware has only one    ;
;                           DMA register set.  In addition, if any channel is ;
;                           mapped through this register set, then all        ;
;                           channels are mapped through it.  For LIM standard ;
;                           boards, this value is zero.                       ;
;                                                                             ;
; C USE CONVENTION:   unsigned int   status;                                  ;
;                     HW_INFO_STRUCT hw_info;                                 ;
;                                                                             ;
;                     status = get_hw_info (&hw_info);                        ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_hw_info		PROC                                                  \
			USES DI,                                              \
			ptr_hw_info_struct:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get a structure describing the expanded memory H/W info       ;
	;   .   from EMM;                                                     ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_emm_hardware_info_fcn
	MOVE		ES:DI, ptr_hw_info_struct
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_hw_info		ENDP

END
