;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM25_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_mappable_regions                                    ;
;                                                                             ;
;      DESCRIPTION:   This function returns an array containing the segment   ;
;                     address and physical page number for each mappable      ;
;                     physical page within BOTH the conventional and expanded ;
;                     memory ranges in a system.  The contents of this array  ;
;                     provide a cross reference between physical page numbers ;
;                     and the actual segment addresses for each mappable page ;
;                     of conventional and expanded memory in the system.  The ;
;                     array is sorted in ascending segment order.  This does  ;
;                     not mean that the physical page numbers associated with ;
;                     the segment addresses are also in ascending order.      ;
;                                                                             ;
;           PASSED:   &mr_count:                                              ;
;                        is a far pointer to a count of the number of entries ;
;                        in the mr array of structures that will be returned  ;
;                        by the function.                                     ;
;                                                                             ;
;                     mr:                                                     ;
;                        is a far pointer to an application-supplied          ;
;                        array of structures that will be initialized by the  ;
;                        function.                                            ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     mr_count:                                               ;
;                        is a count of the number of entries in the mr        ;
;                        array of structures returned by the function.        ;
;                                                                             ;
;                     mr:                                                     ;
;                        is an application supplied structure that contains   ;
;                        two elements initialized by the function.  The       ;
;                        structure members are described here:                ;
;                                                                             ;
;                        mr.mappable_region_seg:                              ;
;                           is the segment address of the corresponding       ;
;                           physical page.  The array entries are sorted in   ;
;                           ascending segment address order.                  ;
;                                                                             ;
;                        mr.phys_page:                                        ;
;                           is the physical page number of the corresponding  ;
;                           segment address.  The physical page numbers are   ;
;                           not in ascending order.                           ;
;                                                                             ;
; C USE CONVENTION:   unsigned int           status;                          ;
;                     unsigned int           mr_count;                        ;
;                     MAPPABLE_REGION_STRUCT mr [MAX_MAPPABLE_REGIONS];       ;
;                                                                             ;
;                     status = get_mappable_regions (&mr_count,               ;
;                                                    mr);                     ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_mappable_regions	PROC                                                  \
			USES DI,                                              \
			ptr_mappable_region_count:FAR PTR WORD,                   \
			ptr_mappable_region_struct:FAR PTR BYTE                  

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the mappable seg struct from EMM;                         ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_mappable_phys_addr_array_fcn
	MOVE		ES:DI, ptr_mappable_region_struct
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the # of entries in the mappable seg struct back to      ;
	;   .   the caller;                                                   ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_mappable_region_count
	MOVE		ES:[BX], CX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_mappable_regions	ENDP

END
