;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM20_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   set_handle_name                                         ;
;                                                                             ;
;      DESCRIPTION:   This function assigns an eight-character name to a      ;
;                     handle.  There is no restriction on the characters      ;
;                     which may be used in the handle name (may be            ;
;                     00h through FFh).                                       ;
;                                                                             ;
;                     At installation, all handles have their names           ;
;                     initialized to ASCII nulls (binary zeros).  By          ;
;                     definition, a handle thus initialized has no name.      ;
;                     To name a handle, make at least one character in        ;
;                     the name a non-null character (to distinguish it from   ;
;                     a handle without a name.)  No two handles may have      ;
;                     the same name.                                          ;
;                                                                             ;
;                     A handle can be renamed at any time by setting its      ;
;                     name to a new value.  A handle can have its name        ;
;                     removed by setting the name to all ASCII nulls.         ;
;                     When a handle is deallocated, its name is removed       ;
;                     (set to ASCII nulls).                                   ;
;                                                                             ;
;           PASSED:   &handle_name:                                           ;
;                        is a far pointer to a structure containing the       ;
;                        name that is to be assigned to the handle.  The      ;
;                        structure member is described here:                  ;
;                                                                             ;
;                        name:                                                ;
;                           is an array of chars that holds the handle's      ;
;                           name.  If the handle's name is less than eight    ;
;                           characters long, you must add nulls to make it    ;
;                           eight characters.                                 ;
;                                                                             ;
;                     handle:                                                 ;
;                        is the handle to which the name is to be assigned.   ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int       status;                              ;
;                     unsigned int       handle;                              ;
;                     HANDLE_NAME_STRUCT handle_name;                         ;
;                                                                             ;
;                     status = set_handle_name (&hn,                          ;
;                                               handle);                      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

set_handle_name		PROC                                                  \
			USES DS SI,                                           \
			ptr_handle_name:FAR PTR BYTE,                             \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   set the current name of the specified handle;                 ;
	;---------------------------------------------------------------------;
	MOVE		AX, set_handle_name_fcn
	MOVE		DX, handle
	MOVE		DS:SI, ptr_handle_name
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

set_handle_name		ENDP

END
