;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM20_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_handle_name                                         ;
;                                                                             ;
;      DESCRIPTION:   This function gets the eight-character name currently   ;
;                     assigned to a handle.  There is no restriction on the   ;
;                     characters which may be used in the handle name (that   ;
;                     is, anything from 00h through FFh).                     ;
;                                                                             ;
;                     The handle name is initialized to ASCII nulls (binary   ;
;                     zeros) at three times:  when the memory manager is      ;
;                     installed, when a handle is allocated, and when a       ;
;                     handle is deallocated.  By definition, a handle thus    ;
;                     initialized has no name.  To name a handle, you must    ;
;                     make at least one character in the name a non-null      ;
;                     character (to distinguish it from a handle without      ;
;                     a name.)                                                ;
;                                                                             ;
;           PASSED:   &handle_name:                                           ;
;                        is a far pointer to a structure into which the name  ;
;                        currently assigned to the handle will be copied.     ;
;                                                                             ;
;                     handle:                                                 ;
;                        is the handle for which the name is to be returned.  ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     handle_name:                                            ;
;                        is the name currently assigned to the handle.  The   ;
;                        structure member is described here:                  ;
;                                                                             ;
;                        name:                                                ;
;                           is an array of chars that holds the handle's      ;
;                           name.                                             ;
;                                                                             ;
; C USE CONVENTION:   unsigned int       status;                              ;
;                     unsigned int       handle;                              ;
;                     HANDLE_NAME_STRUCT handle_name;                         ;
;                                                                             ;
;                     status = get_handle_name (&handle_name,                 ;
;                                               handle);                      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_handle_name		PROC                                                  \
			USES DI,                                              \
			ptr_handle_name:FAR PTR BYTE,                             \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the current name of the specified handle;                 ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_handle_name_fcn
	MOVE		DX, handle
	MOVE		ES:DI, ptr_handle_name
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_handle_name		ENDP

END
