;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM19_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_attrib_capability                                   ;
;                                                                             ;
;      DESCRIPTION:   This function can be used to determine whether the      ;
;                     memory manager can support the non-volatile attribute.  ;
;                     (Read EMMLIB25.ASM or EMMLIB26.ASM for more information ;
;                     about handle attributes.)                               ;
;                                                                             ;
;           PASSED:   &attrib_capability:                                     ;
;                        is a far pointer to the memory managers attribute    ;
;                        capability.                                          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     attrib_capability:                                      ;
;                        is the memory manager handle attribute capability.   ;
;                        A value of zero indicates that the memory manager    ;
;                        and hardware supports only volatile handles.  A      ;
;                        value of one indicates that the memory               ;
;                        manager/hardware supports both volatile and          ;
;                        non-volatile handles.                                ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int attrib_capability;                         ;
;                                                                             ;
;                     status = get_attrib_capability (&attrib_capability);    ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_attrib_capability	PROC	ptr_attrib_capability:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get EMMs handle attribute capabilities;                       ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_attrib_capability_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the handle attribute capability back to the caller;      ;
	;---------------------------------------------------------------------;
	MOVE		DH:DL, 0:AL
	MOVE		ES:BX, ptr_attrib_capability
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_attrib_capability	ENDP

END
