;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM19_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   set_handle_attrib                                       ;
;                                                                             ;
;      DESCRIPTION:   This function can be used to modify the attribute which ;
;                     a handle has associated with it.  The attributes which  ;
;                     a handle may have are volatile or non-volatile.         ;
;                                                                             ;
;                     If the handle's attribute has been set to non-volatile, ;
;                     the handle, its name (if it is assigned one), and the   ;
;                     contents of the pages allocated to the handle are all   ;
;                     maintained after a warm boot.  However, this function   ;
;                     may be disabled with a user option, or may not be       ;
;                     supported by the memory board or system hardware.       ;
;                                                                             ;
;                     A volatile handle attribute instructs the memory        ;
;                     manager to deallocate both the handle and the pages     ;
;                     allocated to it after a warm boot.  If all handles      ;
;                     have the volatile attribute (the default attribute)     ;
;                     at warm boot, the handle directory will be empty and    ;
;                     all of expanded memory will be initialized to zero      ;
;                     immediately after a warm boot.                          ;
;                                                                             ;
;           PASSED:   attrib:                                                 ;
;                        is an open EMM handle's new attribute.  A value of   ;
;                        zero indicates that the handle should be made        ;
;                        volatile.  A value of one indicates that the handle  ;
;                        should be made non-volatile.                         ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int attrib;                                    ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     attrib = VOLATILE;                                      ;
;                     status = set_handle_attrib (attrib,                     ;
;                                                 handle);                    ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

set_handle_attrib	PROC                                                  \
			attrib:WORD,                                          \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   set the current attribute of the specified handle;            ;
	;---------------------------------------------------------------------;
	MOVE		AX, set_handle_attrib_fcn
	MOVE		DX, handle
	MOVE		BX, attrib
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

set_handle_attrib	ENDP

END
