;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM15_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   set_context                                             ;
;                                                                             ;
;      DESCRIPTION:   This function restores the mapping context for all      ;
;                     mappable memory regions (conventional and expanded).    ;
;                     The function copies the contents of a source structure  ;
;                     into the mapping hardware on each expanded memory board ;
;                     in the system.  The application must pass a pointer to  ;
;                     the source structure.  set_context doesn't require an   ;
;                     EMM handle.                                             ;
;                                                                             ;
;                     Use this function instead of save_context &             ;
;                     restore_context if you need to save or restore the      ;
;                     mapping context but don't want to (or have to) use a    ;
;                     handle.                                                 ;
;                                                                             ;
;           PASSED:   &source_context:                                        ;
;                        is a far pointer to the source structure of the      ;
;                        mapping context to be restored.  The application     ;
;                        must point to a structure array which contains the   ;
;                        mapping hardware state.                              ;
;                        The structure member is described here:              ;
;                                                                             ;
;                        source_context.reserved:                             ;
;                           is a character array which is reserved for use by ;
;                           the memory manager.  In this instance it contains ;
;                           the data for the mapping hardware state.          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int   status;                                  ;
;                     CONTEXT_STRUCT source_context;                          ;
;                                                                             ;
;                     status = set_context (&source_context);                 ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

set_context		PROC                                                  \
			USES DS SI,                                           \
			ptr_source_context:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   set the current memory mapping context to EMM;                ;
	;---------------------------------------------------------------------;
	MOVE		AX, set_page_map_fcn
	MOVE		DS:SI, ptr_source_context
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

set_context		ENDP

END
