;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM03_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_unalloc_page_count                                  ;
;                                                                             ;
;      DESCRIPTION:   This function returns the number of unallocated         ;
;                     expanded memory pages.                                  ;
;                                                                             ;
;           PASSED:   &unalloc_page_count:                                    ;
;                        is a far pointer to the unallocated page count.      ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     unalloc_page_count:                                     ;
;                        is the number of expanded memory pages currently     ;
;                        available for use (unallocated).                     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int unalloc_page_count;                        ;
;                                                                             ;
;                     status = get_unalloc_page_count (&unalloc_page_count);  ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_unalloc_page_count	PROC                                                  \
			ptr_unalloc_page_count:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get total & unallocated page counts from EMM;                 ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_unalloc_page_cnt_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass unallocated page count back to the caller;               ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_unalloc_page_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_unalloc_page_count	ENDP

PAGE
END
