;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM01_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   EMM_installed                                           ;
;                                                                             ;
;      DESCRIPTION:   This function checks to determine whether EMM is        ;
;                     installed using the "get interrupt vector" technique    ;
;                     outlined in the LIM Expanded Memory Specification.      ;
;                                                                             ;
;           PASSED:   Nothing.                                                ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                                                                             ;
;                     status = emm_installed ();                              ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE
;-----------------------------------------------------------------------------;
;                 CONSTANT DATA USED BY THE INTERFACE LIBRARY                 ;
;-----------------------------------------------------------------------------;

EMM_driver_name		DB      'EMMXXXX0'
EMM_DRIVER_NAME_LEN	EQU	($ - EMM_driver_name)

EMM_installed		PROC                                                  \
			USES DS SI DI

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the SEGMENT portion of the EMM interrupt vector;          ;
	;   .   it is needed for the following signature compare;             ;
	;---------------------------------------------------------------------;
	MOVE		AH:AL, GET_INT_VECTOR:EMM_INT
	INT		DOS_INT

	;---------------------------------------------------------------------;
	;   .   look for the EMM installation signature in memory;            ;
	;---------------------------------------------------------------------;
	MOVE		DI,    <OFFSET generic_driver_name>
	MOVE		DS:SI, <OFFSET EMM_driver_name>
	MOVE		CX, EMM_DRIVER_NAME_LEN
	CLD
	REPE		CMPSB

	;---------------------------------------------------------------------;
	;   .   if (EMM signature not found--EMM is not installed)            ;
	;   .   .   pseudo EMM status = s/w error;                            ;
	;   .   else                                                          ;
	;   .   .   pseudo EMM status = function passed;                      ;
	;---------------------------------------------------------------------;
	MOVE		AH, software_err_stat
	JNE		EMM_installed_exit
	MOVE		AH, fcn_passed_stat

EMM_installed_exit:
	;---------------------------------------------------------------------;
	;   .   return (pseudo EMM status);                                   ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

EMM_installed		ENDP

END
