;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM24_A.ASM                                             ;
;                                                                             ;
;     FUNCTION NAME:   move_memory_region                                     ;
;                                                                             ;
;      DESCRIPTION:   This function copies a region of memory in the          ;
;                     following memory source/destination combinations.       ;
;                                                                             ;
;                        1. conventional memory to conventional memory        ;
;                        2. conventional memory to expanded memory            ;
;                        3. expanded memory to conventional memory            ;
;                        4. expanded memory to expanded memory                ;
;                                                                             ;
;                     You do not have to save and restore the expanded memory ;
;                     mapping context to perform these move operations.  The  ;
;                     current mapping context is maintained throughout this   ;
;                     operation.                                              ;
;                                                                             ;
;                     The length of the region is limited by the amount of    ;
;                     expanded memory allocated to the handles specified.     ;
;                     However, in most practical applications, the region     ;
;                     length will be considerably smaller.  A region length   ;
;                     of zero is not an error, and no move will be performed. ;
;                                                                             ;
;                     A region length which exceeds 16K bytes is not an       ;
;                     error.  In this case the function assumes that a group  ;
;                     of logical pages is the target for the move.  The       ;
;                     logical page specified represents the first logical     ;
;                     page in which the move will take place.  If the region  ;
;                     length exceeds 16K bytes, or if the region is less than ;
;                     16K bytes but spans logical pages, there must be        ;
;                     sufficient logical pages remaining after the first      ;
;                     logical page for the entire region to fit.              ;
;                                                                             ;
;                     If your application needs to save a region of           ;
;                     conventional memory in expanded memory, you can move it ;
;                     without having to perform a save or restore of the      ;
;                     current mapping context.  The memory manager maintains  ;
;                     the context.  A move of up to 1M byte may be performed, ;
;                     although practical lengths are substantially less than  ;
;                     this value.                                             ;
;                                                                             ;
;                     If the source and destination handles are identical,    ;
;                     the source and destination regions are tested for       ;
;                     overlap before the move.  If they overlap, the move     ;
;                     direction is chosen so that the destination region      ;
;                     receives an intact copy of the source region.  A status ;
;                     will be returned indicating that this overlap has       ;
;                     occurred.                                               ;
;                                                                             ;
;           PASSED:   &ms:                                                    ;
;                        is a far pointer to a structure which contains       ;
;                        the source and destination information for the move. ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        ms.region_size:                                      ;
;                           is the length of the memory region (in bytes) to  ;
;                           be moved.                                         ;
;                                                                             ;
;                        ms.source_mem_type:                                  ;
;                           is the type of memory where the source region     ;
;                           resides.  A value of zero indicates that the      ;
;                           source region resides in conventional memory      ;
;                           (excluding the page frame segment).  A value of   ;
;                           one indicates that the source region resides in   ;
;                           expanded memory.                                  ;
;                                                                             ;
;                        ms.source_handle:                                    ;
;                           if the source region resides in expanded memory,  ;
;                           it specifies the handle number associated with    ;
;                           the source memory region.  If the source region   ;
;                           resides in conventional memory, it has no meaning ;
;                           and should be set to zero for future              ;
;                           compatibility.                                    ;
;                                                                             ;
;                        ms.source_init_offset:                               ;
;                           is the offset within the source region at which   ;
;                           to begin the move.                                ;
;                                                                             ;
;                           If the source region resides in expanded memory,  ;
;                           it specifies an offset relative to the beginning  ;
;                           of the 16K-byte source page.  Because the offset  ;
;                           is relative to the beginning of a 16K-byte source ;
;                           expanded memory page, it may only take on values  ;
;                           between 0000h and 3FFFh.                          ;
;                                                                             ;
;                           If the source region resides in conventional      ;
;                           memory, it specifies the offset, relative to the  ;
;                           beginning of the source segment, at which to      ;
;                           begin the move.  Because the offset is relative   ;
;                           to the beginning of a 64K-byte conventional       ;
;                           memory segment, it may take on values between     ;
;                           0000h and FFFFh.                                  ;
;                                                                             ;
;                        ms.source_init_log_page_or_seg:                      ;
;                           is the initial segment or logical page number     ;
;                           within the source region at which to begin the    ;
;                           move.                                             ;
;                                                                             ;
;                           If the source region resides in expanded memory,  ;
;                           it specifies the logical page within the source   ;
;                           region at which to begin the move.                ;
;                                                                             ;
;                           If the source region resides in conventional      ;
;                           memory, it specifies the initial segment address  ;
;                           within conventional memory at which to begin      ;
;                           the move.                                         ;
;                                                                             ;
;                        ms.dest_mem_type:                                    ;
;                           is the type of memory where the destination       ;
;                           region resides.  A value of zero indicates        ;
;                           conventional memory.  A value of one indicates    ;
;                           expanded memory.                                  ;
;                                                                             ;
;                        ms.dest_handle:                                      ;
;                           if the destination region resides in expanded     ;
;                           memory, it specifies the handle number associated ;
;                           with the destination memory region.               ;
;                                                                             ;
;                           If the destination region resides in conventional ;
;                           memory, it has no meaning and should be set to    ;
;                           zero for future compatibility.                    ;
;                                                                             ;
;                        ms.dest_init_offset:                                 ;
;                           is the offset within the destination region at    ;
;                           which to begin the move.                          ;
;                                                                             ;
;                           If the destination region resides in expanded     ;
;                           memory, it specifies an offset relative to the    ;
;                           beginning of the 16K-byte destination page.       ;
;                           Because the offset is relative to the beginning   ;
;                           of a 16K-byte source expanded memory page, it may ;
;                           only take on values between 0000h and 3FFFh.      ;
;                                                                             ;
;                           If the destination region resides in conventional ;
;                           memory, it specifies the offset, relative to the  ;
;                           beginning of the destination segment, to begin    ;
;                           the move.  Because the offset is relative to the  ;
;                           beginning of a 64K conventional memory segment,   ;
;                           it may take on values between 0000h and FFFFh.    ;
;                                                                             ;
;                        ms.dest_init_log_page_or_seg:                        ;
;                           is the initial segment or logical page number     ;
;                           within the destination region at which to begin   ;
;                           the move.                                         ;
;                                                                             ;
;                           If the destination region resides in expanded     ;
;                           memory then the value specifies the logical page  ;
;                           within the destination region at which to begin   ;
;                           the move.                                         ;
;                                                                             ;
;                           If the destination region resides in conventional ;
;                           memory, it specifies the initial segment address  ;
;                           within conventional memory at which to begin      ;
;                           the move.                                         ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     The SOURCE memory region described by:                  ;
;                           ms.source_handle                                  ;
;                           ms.source_init_offset                             ;
;                           ms.source_init_log_page_or_seg                    ;
;                       is MOVED into the DESTINATION memory region:          ;
;                           ms.dest_handle                                    ;
;                           ms.dest_init_offset                               ;
;                           ms.dest_init_log_page_or_seg                      ;
;                                                                             ;
; C USE CONVENTION:   unsigned int     status;                                ;
;                     MOVE_XCHG_STRUCT ms;                                    ;
;                                                                             ;
;                     ms.region_size                 = 640 * 1024;            ;
;                     ms.source_mem_type             = CONV_MEM;              ;
;                     ms.source_handle               = 0;                     ;
;                     ms.source_init_log_page_or_seg = 0x0000;                ;
;                     ms.source_init_offset          = 0x0000;                ;
;                     ms.dest_mem_type               = EXP_MEM;               ;
;                     ms.dest_handle                 = 1;                     ;
;                     ms.dest_init_log_page_or_seg   = 0;                     ;
;                     ms.dest_init_offset            = 0x0000;                ;
;                                                                             ;
;                     status = move_memory_region (&ms);                      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

move_memory_region	PROC                                                  \
			USES DS SI,                                           \
			ptr_move_struct:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   move the contents of a source memory region to a destination  ;
	;   .   memory region;                                                ;
	;---------------------------------------------------------------------;
	MOVE		AX, move_memory_fcn 
	MOVE		DS:SI, ptr_move_struct
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

move_memory_region	ENDP

END
