;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM22_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   alter_map_jump                                          ;
;                                                                             ;
;      DESCRIPTION:   This function alters the memory mapping context and     ;
;                     transfers control to the specified address.  (It is     ;
;                     analogous to the FAR JUMP in the 8086 family            ;
;                     architecture.)  When you invoke this function, you lose ;
;                     the memory mapping context which existed before the     ;
;                     invocation.                                             ;
;                                                                             ;
;                     Mapping no pages and jumping is not considered an       ;
;                     error.  If you request to map zero pages and jump,      ;
;                     this function transfers control to the target address   ;
;                     and performs a far jump.                                ;
;                                                                             ;
;           PASSED:   mode:                                                   ;
;                        is a flag indicating whether the values contained    ;
;                        in the map.phys_page_or_seg structure members are    ;
;                        physical page numbers or the segment addresses of    ;
;                        the physical pages. A zero indicates that the values ;
;                        are physical page numbers.  A one indicates that the ;
;                        values are the segment addresses of the physical     ;
;                        pages.                                               ;
;                                                                             ;
;                                                                             ;
;                     &mj:                                                    ;
;                        is a far pointer to a structure that contains the    ;
;                        information necessary to map the desired physical    ;
;                        pages and jump to the target address.                ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        mj.target_function:                                  ;
;                           is a far pointer which contains the target        ;
;                           address to which control is to be transferred.    ;
;                                                                             ;
;                        mj.map_struct_count:                                 ;
;                           is the number of entries in the map array of      ;
;                           structures.  The map array of structures can      ;
;                           contain as many entries as the application        ;
;                           developer needs to map the desired logical pages  ;
;                           into physical pages.  The number of entries can't ;
;                           exceed the number of mappable pages in the system.;
;                                                                             ;
;                        mj.ptr_map_struct:                                   ;
;                           is a far pointer to the map array of structures   ;
;                           which contain the logical page numbers and        ;
;                           physical pages or segment address at which they   ;
;                           are to be mapped.                                 ;
;                           The structure members are described here:         ;
;                                                                             ;
;                           map.log_page:                                     ;
;                              is the logical page to be mapped.              ;
;                                                                             ;
;                           map.phys_page_or_seg:                             ;
;                              is either the physical page number or the      ;
;                              segment address representation of the physical ;
;                              page number at which the previous logical page ;
;                              number is to be mapped.  The mode parameter    ;
;                              determines the type of representation.         ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int    status;                                 ;
;                     unsigned int    mode;                                   ;
;                     unsigned int    handle;                                 ;
;                     MAP_STRUCT      map[MAX_MAPPABLE_REGIONS];              ;
;                     MAP_JUMP_STRUCT mj;                                     ;
;                                                                             ;
;                     map[0].log_page         = 0;                            ;
;                     map[0].phys_page_or_seg = 0xC000;                       ;
;                     map[1].log_page         = 1;                            ;
;                     map[1].phys_page_or_seg = 0xC400;                       ;
;                     map[2].log_page         = 2;                            ;
;                     map[2].phys_page_or_seg = 0xC800;                       ;
;                     map[3].log_page         = 3;                            ;
;                     map[3].phys_page_or_seg = 0xCC00;                       ;
;                                                                             ;
;                     mode                = SEG_MODE;                         ;
;                     mj.target_function  = 0xC0000000;                       ;
;                     mj.map_struct_count = 4;                                ;
;                     mj.ptr_map_struct   = map;                              ;
;                                                                             ;
;                     status = alter_map_jump (mode,                          ;
;                                              &mj,                           ;
;                                              handle);                       ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alter_map_jump		PROC                                                  \
			USES DS SI,                                           \
			mode:BYTE,                                            \
			ptr_map_struct:FAR PTR BYTE,                              \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   alter the current mapping context & jump to the target        ;
	;   .   address;                                                      ;
	;---------------------------------------------------------------------;
	MOVE		AH, alter_page_map_and_jmp_fcn
	MOVE		AL, mode
	MOVE		DX, handle
	MOVE		DS:SI, ptr_map_struct
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   if the EMM call failed return (EMM status);                   ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alter_map_jump		ENDP

END
