;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM17_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   map_unmap_pages                                         ;
;                                                                             ;
;      DESCRIPTION:   This function can, in a single invocation, map (or      ;
;                     unmap) logical pages into as many physical pages as the ;
;                     system supports.  Consequently, it has less execution   ;
;                     overhead than mapping pages one at a time.  For         ;
;                     applications that do a lot of page mapping, this is     ;
;                     the preferred mapping method.                           ;
;                                                                             ;
;                     Mapping Multiple Pages:                                 ;
;                     The handle passed to this function determines what type ;
;                     of logical pages are being mapped.  Logical pages       ;
;                     allocated by the alloc_pages & alloc_std_pages functions;
;                     are referred to as pages, and are 16K bytes.  Logical   ;
;                     pages allocated by the alloc_raw_pages function are     ;
;                     referred to as raw pages, and might not be 16K bytes.   ;
;                                                                             ;
;                     Unmapping Multiple Pages:                               ;
;                     This function can make specific physical pages          ;
;                     unavailable for reading or writing.  A logical page     ;
;                     that is unmapped from a specific physical page can't    ;
;                     be read or written from that physical page.  The        ;
;                     unmapped logical page can be made available again       ;
;                     by mapping it or a new logical page at the physical     ;
;                     page that was unmapped.  (Unmap a physical page by      ;
;                     setting the logical page it is associated with to -1.   ;
;                                                                             ;
;                     For example, you might unmap an entire set of mapped    ;
;                     pages before loading and executing a program.  This     ;
;                     ensures that the loaded program won't be able to access ;
;                     the pages your program has mapped.  However, you must   ;
;                     save the mapping context before you unmap the physical  ;
;                     pages.  This enables you to restore it later and        ;
;                     access the memory you had mapped there.  You can save   ;
;                     or restore the mapping context with any of the EMMLIB   ;
;                     functions dedicated to doing so.                        ;
;                                                                             ;
;                     Mapping and Unmapping Multiple Pages Simultaneously:    ;
;                     Both mapping and unmapping pages can be done in the     ;
;                     same invocation.  Mapping or unmapping no pages is not  ;
;                     considered an error.  If a request to map or unmap zero ;
;                     pages is made, nothing is done and no error is          ;
;                     returned.                                               ;
;                                                                             ;
;                     Alternate Mapping and Unmapping Methods:                ;
;                     You can map or unmap pages using two methods.  Both     ;
;                     methods produce identical results.                      ;
;                     1. The first method specifies both a logical page and a ;
;                        physical page at which the logical page will be      ;
;                        mapped.  This method is an extension of the          ;
;                        map_page function.                                   ;
;                     2. The second method specifies both a logical page and  ;
;                        a corresponding segment address at which the logical ;
;                        page will be mapped.  (While this performs the same  ;
;                        function as the first method, it may be easier to    ;
;                        use the actual segment address of a physical page    ;
;                        than to use a number which only represents its       ;
;                        location.)  The memory manager checks whether the    ;
;                        specified segment address falls on the boundary of a ;
;                        mappable physical page.  The manager then translates ;
;                        the segment address passed to it into the necessary  ;
;                        internal representation to map the pages.            ;
;                                                                             ;
;           PASSED:   mode:                                                   ;
;                        is a flag that specifies whether the                 ;
;                        mu.phys_page_or_seg members in the mu array of       ;
;                        structures are physical pages or segment values.     ;
;                        A zero specifies that the mu.phys_page_or_seg        ;
;                        members are physical pages.  A one specifies that    ;
;                        the mu.phys_page_or_seg members are segments.        ;
;                                                                             ;
;                     mu_count:                                               ;
;                        is the number of entries in the mu array of          ;
;                        structures.  For example, if the array contained     ;
;                        four pages to map or unmap, then mu_count would be   ;
;                        four.  mu_count should not exceed the number of      ;
;                        mappable pages in the system.                        ;
;                                                                             ;
;                     mu:                                                     ;
;                        is a far pointer to an array of structures that      ;
;                        contains the information necessary to map the        ;
;                        desired pages.                                       ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        mu.log_page:                                         ;
;                           is the number of the logical page to be mapped.   ;
;                           Logical pages are numbered relative to zero, so   ;
;                           the number for a logical page ranges from         ;
;                           zero to (maximum number of logical pages          ;
;                           allocated to the handle - 1).                     ;
;                                                                             ;
;                           If the logical page number is set to -1, the      ;
;                           physical page associated with it is unmapped      ;
;                           rather than mapped.  Unmapping a physical page    ;
;                           makes it inaccessible for reading or writing.     ;
;                                                                             ;
;                        mu.phys_page_or_seg:                                 ;
;                           is the physical page number or segment at which   ;
;                           the logical page is to be mapped.                 ;
;                                                                             ;
;                           Physical pages are numbered zero relative, so the ;
;                           number for a physical page can only range from    ;
;                           zero to (maximum number of physical pages         ;
;                           supported in the system - 1).                     ;
;                                                                             ;
;                           A segment address must correspond exactly to a    ;
;                           mappable segment address.  The mappable segment   ;
;                           addresses are available with the                  ;
;                           get_mappable_regions function.                    ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int mode;                                      ;
;                     unsigned int mu_count;                                  ;
;                     unsigned int handle;                                    ;
;                     MAP_STRUCT   mu[MAX_MAPPABLE_REGIONS];                  ;
;                                                                             ;
;                     mode                   = SEG_MODE;                      ;
;                     mu_count               = 2;                             ;
;                     mu[0].log_page         = 0;                             ;
;                     mu[0].phys_page_or_seg = 0xC000;                        ;
;                     mu[1].log_page         = 1;                             ;
;                     mu[1].phys_page_or_seg = 0xC400;                        ;
;                     status = map_unmap_pages (mode,                         ;
;                                               mu_count,                     ;
;                                               mu,                           ;
;                                               handle);                      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

map_unmap_pages		PROC                                                  \
			USES DS SI,                                           \
			mode:BYTE,                                            \
			map_unmap_struct_count:WORD,                          \
			ptr_map_unmap_struct:FAR PTR BYTE,                        \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   map/unmap the list of mappable pages specified by the app;    ;
	;---------------------------------------------------------------------;
	MOVE		AH, map_mult_page_fcn
	MOVE		AL, mode
	MOVE		DX, handle
	MOVE		DS:SI, ptr_map_unmap_struct
	MOVE		CX, map_unmap_struct_count
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

map_unmap_pages		ENDP

END
