;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM16_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_partial_context                                     ;
;                                                                             ;
;      DESCRIPTION:   This function saves a partial mapping context for       ;
;                     specific mappable memory regions in a system.  Because  ;
;                     this function saves only a subset of the entire mapping ;
;                     context, it uses less memory for the save structure and ;
;                     may be potentially faster than get_context.  The        ;
;                     function copies the contents of selected mapping        ;
;                     hardware from each expanded memory board to a           ;
;                     destination structure.                                  ;
;                                                                             ;
;                     The application must pass a pair of far pointers.  The  ;
;                     first points to a structure that specifies which        ;
;                     mappable segments to save.  The second points to the    ;
;                     destination structure.                                  ;
;                                                                             ;
;                     Use this function instead of save_context &             ;
;                     restore_context if you need to save or restore the      ;
;                     mapping context but don't want to (or have to) use a    ;
;                     handle.                                                 ;
;                                                                             ;
;           PASSED:   &pcl:                                                   ;
;                        is a far pointer to a structure that specifies only ;
;                        those mappable memory regions which are to have      ;
;                        their mapping context saved.                         ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        pcl.mappable_region_count:                           ;
;                           is the number of entries in the                   ;
;                           mappable_region_seg() array member (the one       ;
;                           immediately following mappable_region_count).     ;
;                           This number should not exceed the number of       ;
;                           mappable segments in the system.                  ;
;                                                                             ;
;                        pcl.mappable_region_seg():                           ;
;                           is the segment addresses of the mappable memory   ;
;                           regions whose mapping contexts are to be saved.   ;
;                           The segment address must be a mappable segment.   ;
;                           Use the get_mappable_regions function to          ;
;                           determine which segments are mappable.            ;
;                                                                             ;
;                     &dest_context:                                          ;
;                        is a far pointer to the destination structure of the ;
;                        mapping context to be saved.                         ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     dest_context:                                           ;
;                        is a structure containing the state of all the       ;
;                        mapping hardware on all boards in the system.  It    ;
;                        also contains any information necessary to restore   ;
;                        the boards to their original state when the program  ;
;                        invokes a set_context or get_set_context function.   ;
;                        The structure member is described here:              ;
;                                                                             ;
;                        dest_context.reserved:                               ;
;                           is a character array which is reserved for use by ;
;                           the memory manager.  In this instance it contains ;
;                           the data for the mapping hardware state.          ;
;                                                                             ;
; C USE CONVENTION:   unsigned int                status;                     ;
;                     PARTIAL_CONTEXT_LIST_STRUCT pcl [MAX_MAPPABLE_REGIONS]; ;
;                     CONTEXT_STRUCT              dest_context;               ;
;                                                                             ;
;                     pcl.mappable_region_count  = 2;                         ;
;                     pcl.mappable_region_seg[0] = 0xC000;                    ;
;                     pcl.mappable_region_seg[1] = 0xC400;                    ;
;                     status = get_partial_context (&pcl,                     ;
;                                                   &dest_context);           ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_partial_context	PROC                                                  \
			USES DS SI DI,                                        \
			ptr_context_list_struct:FAR PTR BYTE,                     \
			ptr_context:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the partial mapping context from EMM;                     ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_partial_page_map_fcn
	MOVE		DS:SI, ptr_context_list_struct
	MOVE		ES:DI, ptr_context
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_partial_context	ENDP

END
