;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM15_D.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_context_size                                        ;
;                                                                             ;
;      DESCRIPTION:   This function returns the storage requirements for the  ;
;                     structure passed by the get_context, set_context, and   ;
;                     get_set_context functions.  Use this function when you  ;
;                     want to dynamically allocate this space.  This function ;
;                     doesn't require an EMM handle.                          ;
;                                                                             ;
;           PASSED:   &context_size:                                          ;
;                        is a far pointer to the size of the mapping context  ;
;                        structure.                                           ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     context_size:                                           ;
;                        is the size of the mapping context structure.        ;
;                        Normally, you just supply a CONTEXT_STRUCT structure ;
;                        which contains an array of the largest space         ;
;                        possible (currently 255 bytes).  However, if you     ;
;                        want to dynamically allocate the exact amount of     ;
;                        space required to save a context, use this function  ;
;                        to get the size needed.  (See example below.)  The   ;
;                        size depends on how the expanded memory system is    ;
;                        configured and how the expanded memory manager is    ;
;                        implemented.                                         ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int context_size;                              ;
;                     void         *context;                                  ;
;                                                                             ;
;                     status = get_context_size (&context_size);              ;
;                     if (status == PASSED)                                   ;
;                     {                                                       ;
;                        context = malloc (context_size);                     ;
;                        if (context == NULL)                                 ;
;                           /* error condition (no memory to allocate) */     ;
;                        else                                                 ; 
;                        {                                                    ;
;                           status = get_context ((CONTEXT_STRUCT *) context);;
;                           if (status == PASSED)                             ;
;                              printf ("context saved\n");                    ;
;                           else                                              ;
;                              /* error condition */                          ;
;                        }                                                    ;
;                     }                                                       ;
;                     else                                                    ;
;                        /* error condition */                                ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_context_size	PROC                                                  \
			ptr_context_size:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the MAXIMUM memory mapping context size from EMM;         ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_size_page_map_array_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the MAX size back to the caller;                         ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_context_size
	MOVE		ES:[BX], AX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_context_size	ENDP

END
