;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM02_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_page_frame_seg                                      ;
;                                                                             ;
;      DESCRIPTION:   This function returns the segment of the LIM page       ;
;                     frame.  The LIM page frame defines a region of memory   ;
;                     above 640K that is AT LEAST four CONTIGUOUS 16K-byte    ;
;                     (64K) blocks in length.  In other words, the page       ;
;                     frame defines a region into which AT LEAST four 16K     ;
;                     pages can be mapped.  You can determine the actual      ;
;                     length of the region using the                          ;
;                     get_mappable_region_count function (EMMLIB38.ASM).      ;
;                                                                             ;
;           PASSED:   &page_frame-seg:                                        ;
;                        is a far pointer to the segment address of the LIM   ;
;                        page frame.                                          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     page_frame_seg:                                         ;
;                        is the segment address of the page frame.            ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int page_frame_seg;                            ;
;                                                                             ;
;                     status = get_page_frame_seg (&page_frame_seg);          ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_page_frame_seg	PROC                                                  \
			ptr_page_frame_seg:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get page frame segment from EMM;                              ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_page_frame_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   convert the page frame segment into a far pointer             ;
	;   .   and pass it back to the caller;                               ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_page_frame_seg
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_page_frame_seg	ENDP

PAGE
END
