
#include   <edutils.h>
#include   <io.h>
#include   <conio.h>


  /* INTERNAL Variables */
ED_PARMS  parms;
char      filename [100];

void main (int argc, char * argv [])
{

    printf ("\n");
    printf ("FILEVIEW Version 1.0\n");
    printf ("(c) Copyright 1994  Kenneth J. Macke\n");
    printf ("\n");

    if (argc > 2) {
error_and_exit:
        printf ("Format:\n");
        printf ("    fileview   [<filename>]\n");
        printf ("where:\n");
        printf ("    [<filename>]  is the optional name of a file to view.\n");
        printf ("                  If left blank, the default file will be README.DOC.\n");
        printf ("\n");
        exit (1);
    }

    strcpy (filename, "README.DOC");

    if (argc == 2) {
        if (strlen (argv [1]) > 80)
            goto error_and_exit;
        strcpy (filename, argv [1]);
    }

    if (access (filename, 0) != 0) {
        printf ("File '%s' not found!%c\n\n", filename, 7);
        exit (1);
    }

    textbackground (BROWN);
    textcolor (YELLOW);
    gotoxy (1,1);
    cprintf ("            FileView V1.0         (c) Copyright 1994  Kenneth J. Macke          ");
    gotoxy (1,24);
    cprintf ("     Arrows -- Move Around            PageUp/PageDown            ESC -- Exit    ");

    ed_set_default_parameters (&parms);

    parms.max_num_lines = 1500;
    parms.max_line_length = 100;

    parms.screen_left = 1;
    parms.screen_right = 80;
    parms.screen_top = 2;
    parms.screen_bottom = 23;

    parms.editing_background = BLUE;
    parms.editing_foreground = WHITE;

    parms.editing_allowed = FALSE;
    parms.message_allowed = FALSE;
    parms.status_allowed = FALSE;

    ed_edit_file_field (&parms, filename);

    textbackground (BLACK);
    textcolor (LIGHTGRAY);
    clrscr ();
    printf ("Thank you for using FileView V1.0\n");

}  /* main */
