#pragma inline
#include <stdio.h>
#include <dos.h>
#include "econ.h"
extern unsigned ec_init;
extern unsigned char ec_attr[][8];
int ecseek(int page, long offset, int fromwhere)
   {
   int new_y, new_x;
   unsigned char lattr;
   unsigned char mode;
   if (!ec_init)
      ecinit();
   new_y = CS_ROW(offset);
   new_x = CS_COL(offset);
   _AH = 15;			      /*request video mode	      */
   geninterrupt(0x10);		      /*bios video interrupt	      */
   mode = _AL;			      /*save mode		      */
   lattr = ec_attr[mode][page];
   switch (mode) {
   case 0:			      /*B&W 40x25		      */
   case 1:			      /*Color 40x25		      */
      if (page < 0 || page > 7)
	 return(EOF);
      break;
   case 2:			      /*B&W 80x25		      */
   case 3:			      /*Color 80x25		      */
   case 7:			      /*monocrome 80x25 	      */
      if (page < 0 || page > 3)
	 return(EOF);
      break;
   case 4:			      /*B&W 40x25 graphics	      */
   case 5:			      /*Color 40x25 graphics	      */
   case 6:			      /*B&W 80x25 graphics	      */
      if (page != 0)
	 return(EOF);
      break;
      }
   switch (fromwhere) {
   case SEEK_SET:
      break;
   case SEEK_CUR:
      _AH = 3;			      /*get cursor position	      */
      _BH = page;		      /*put page in position	      */
      geninterrupt(0x10);	      /*bios video interrupt	      */
      new_y += _DH;		      /*new_y=row		      */
      new_x += _DL;		      /*new_x=column		      */
      break;
   case SEEK_END:
      new_y += 25;
      break;
   default:
      return(EOF);		      /*invalid seek type	      */
      }
   switch (mode) {
   case 0:			      /*B&W 40x25		      */
   case 1:			      /*Color 40x25		      */
   case 4:			      /*B&W 40x25 graphics	      */
   case 5:			      /*Color 40x25 graphics	      */
      while (new_x > 39) {
	 new_y++;
	 new_x -= 40;
	 }
      while (new_x < 0) {
	 new_y--;
	 new_x += 40;
	 }
      break;
   case 2:			      /*B&W 80x25		      */
   case 3:			      /*Color 80x25		      */
   case 6:			      /*B&W 80x25 graphics	      */
   case 7:			      /*monocrome 80x25 	      */
      while (new_x > 79) {
	 new_y++;
	 new_x -= 80;
	 }
      while (new_x < 0) {
	 new_y--;
	 new_x += 80;
	 }
      break;
      }
   if (new_y < 0) {		      /*scroll up		      */
      new_y *= -1;
      asm  push ds;		      /*save current ds 	      */
      asm  push si;		      /*save current si 	      */
      asm  push es;		      /*save current es 	      */
      asm  push di;		      /*save current di 	      */
      asm  std; 		      /*set directn flag to decrement */
      switch (mode) {
      case 0:			      /*B&W 40x25		      */
      case 1:			      /*Color 40x25		      */
	 asm  mov ax,page;	      /*AX=page 		      */
	 asm  mov bx,128;	      /*BX=(page size)/16	      */
	 asm  mul bx;		      /*AX=(page offset)/16	      */
	 asm  mov dx,0b7ffh;	      /*DX=cga adapter base	      */
	 asm  add ax,dx;	      /*AX=page base		      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
      cga40a1:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,1934;	      /*point si to line 23 col 39    */
	 asm  mov di,2014;	      /*point di to line 24 col 39    */
	 asm  mov cx,960;	      /*prepare to move 24 lines      */
	 asm  rep movsw;	      /*execute the move	      */
	 asm  mov al,020h;	      /*load ' ' for last line	      */
	 asm  mov ah,lattr;	      /*load attribute for last line  */
	 asm  mov cx,40;	      /*prepare to blank last line    */
	 asm  rep stosw;	      /*execute blank		      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga40a1;	      /*loop if lines still to scroll */
	 break;
      case 2:			      /*B&W 80x25		      */
      case 3:			      /*Color 80x25		      */
	 asm  mov ax,page;	      /*AX=page 		      */
	 asm  mov bx,256;	      /*BX=(page size)/16	      */
	 asm  mul bx;		      /*AX=(page offset)/16	      */
	 asm  mov dx,0b7ffh;	      /*DX=cga adapter base	      */
	 asm  add ax,dx;	      /*AX=page base		      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
      cga80a1:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,3854;	      /*point si to line 23 col 79    */
	 asm  mov di,4014;	      /*point di to line 24 col 79    */
      cga80b1:
	 asm  cli;		      /*no interrupts		      */
      cga80c1:
	 asm  in al,dx; 	      /*get 6845 status 	      */
	 asm  test al,8;	      /*vertical retrace?	      */
	 asm  jnz cga80e1;	      /*long wait-access ok	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jc cga80c1;	      /*short wait-wait it out	      */
      cga80d1:
	 asm  in al,dx; 	      /*get 6845 status again	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jc cga80d1;	      /*wait for retrace	      */
      cga80e1:
	 asm  movsw;
	 asm  sti;		      /*allow interrupts	      */
	 asm  cmp si,14;	      /*end of screen?		      */
	 asm  jne cga80b1;	      /*no - continue scroll	      */
	 asm  mov cl,020h;	      /*load ' ' for last line	      */
	 asm  mov ch,lattr;	      /*load attr for last line       */
      cga80f1:
	 asm  cli;		      /*no interrupts		      */
      cga80g1:
	 asm  in al,dx; 	      /*get 6845 status 	      */
	 asm  test al,8;	      /*vertical retrace?	      */
	 asm  jnz cga80i1;	      /*long wait-access ok	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jc cga80g1;	      /*short wait-wait it out	      */
      cga80h1:
	 asm  in al,dx; 	      /*get 6845 status again	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jnc cga80h1;	      /*wait for retrace	      */
      cga80i1:
	 asm  mov ax,cx;	      /*get blanking word	      */
	 asm  stosw;		      /*and then to screen	      */
	 asm  sti;		      /*allow interrupts	      */
	 asm  cmp di,14;	      /*end of screen?		      */
	 asm  jne cga80f1;	      /*no - continue blanking	      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga80a1;	      /*loop if lines still to scroll */
	 break;
      case 4:			      /*B&W 40x25 graphics	      */
      case 5:			      /*Color 40x25 graphics	      */
	 asm  mov ax,0b7ffh;	      /*DX=cga adapter base	      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
      cga320a1:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,7694;	      /*point si to line 23 col 39    */
	 asm  mov di,8014;	      /*point di to line 24 col 39    */
	 asm  mov cx,24;
      cga320b1:
	 asm  push cx;
	 asm  mov cx,160;
	 asm  rep movsw;
	 asm  add di,8512;
	 asm  add si,8512;
	 asm  mov cx,160;
	 asm  rep movsw;
	 asm  sub di,8192;
	 asm  sub si,8192;
	 asm  pop cx;
	 asm  loop cga320b1;
	 asm  mov al,lattr;
	 asm  shr al,1;
	 asm  shr al,1;
	 asm  shr al,1;
	 asm  shr al,1;
	 asm  and al,03h;
	 asm  mov cx,8;
      cga320c1:
	 asm  shl bx,1;
	 asm  shl bx,1;
	 asm  or bl,al;
	 asm  loop cga320c1;
	 asm  mov ax,bx;
	 asm  mov cx,160;
	 asm  rep stosw;
	 asm  add di,8512;
	 asm  mov cx,160;
	 asm  rep stosw;
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga320a1;	      /*loop if lines still to scroll */
	 break;
      case 6:			      /*B&W 80x25 graphics	      */
	 asm  mov ax,0b7ffh;	      /*DX=cga adapter base	      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
      cga640a1:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,7694;	      /*point si to line 23 col 79    */
	 asm  mov di,8014;	      /*point di to line 24 col 79    */
	 asm  mov cx,24;	      /*lines to move		      */
      cga640b1: 		      /*beginning of loop	      */
	 asm  push cx;		      /*save loop count 	      */
	 asm  mov cx,160;	      /*CX=words to move	      */
	 asm  rep movsw;	      /*move words		      */
	 asm  add di,8512;
	 asm  add si,8512;
	 asm  mov cx,160;	      /*CX=words to move	      */
	 asm  rep movsw;	      /*move words		      */
	 asm  sub di,8192;
	 asm  sub si,8192;
	 asm  pop cx;		      /*restore loop count	      */
	 asm  loop cga640b1;	      /*end of loop		      */
	 asm  xor ax,ax;	      /*AX=blanking word	      */
	 asm  mov cx,160;	      /*words to blank		      */
	 asm  rep stosw;	      /*blank last line 	      */
	 asm  add di,8512;
	 asm  mov cx,160;	      /*words to blank		      */
	 asm  rep stosw;	      /*blank last line 	      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga640a1;	      /*loop if lines still to scroll */
	 break;
      case 7:
	 asm  mov ax,page;	      /*AX=page 		      */
	 asm  mov bx,256;	      /*BX=(page size)/16	      */
	 asm  mul bx;		      /*AX=(page offset)/16	      */
	 asm  mov dx,0afffh;	      /*DX=cga adapter base	      */
	 asm  add ax,dx;	      /*AX=page base		      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
      mon80a1:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,3854;	      /*point si to line 23 col 79    */
	 asm  xor di,4014;	      /*point di to line 24 col 79    */
	 asm  mov cx,1920;	      /*words to move		      */
	 asm  rep movsw;	      /*move the words		      */
	 asm  mov al,020h;	      /*load ' ' for last line	      */
	 asm  mov ah,lattr;	      /*load attr for last line       */
	 asm  mov cx,80;	      /*words to clear		      */
	 asm  rep stosw;	      /*clear the words 	      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop mon80a1;	      /*loop if lines still to scroll */
	 break;
	 }
      asm  cld; 		      /*clear drctn flag to increment */
      new_y = 0;
      asm  pop di;		      /*restore current di	      */
      asm  pop es;		      /*restore current es	      */
      asm  pop si;		      /*restore current si	      */
      asm  pop ds;		      /*restore current ds	      */
      }
   if (new_y > 24) {		      /*scroll down		      */
      asm  push ds;		      /*save current ds 	      */
      asm  push si;		      /*save current si 	      */
      asm  push es;		      /*save current es 	      */
      asm  push di;		      /*save current di 	      */
      switch (mode) {
      case 0:			      /*B&W 40x25		      */
      case 1:			      /*Color 40x25		      */
	 asm  mov ax,page;	      /*AX=page 		      */
	 asm  mov bx,128;	      /*BX=(page size)/16	      */
	 asm  mul bx;		      /*AX=(page offset)/16	      */
	 asm  mov dx,0b800h;	      /*DX=cga adapter base	      */
	 asm  add ax,dx;	      /*AX=page base		      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
	 asm  sub cx,24;	      /*CX=lines to scroll	      */
      cga40a2:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,80;	      /*point si to line 1	      */
	 asm  xor di,di;	      /*point di to line 0	      */
	 asm  mov cx,960;	      /*prepare to move 24 lines      */
	 asm  rep movsw;	      /*execute the move	      */
	 asm  mov al,020h;	      /*load ' ' for last line	      */
	 asm  mov ah,lattr;	      /*load attribute for last line  */
	 asm  mov cx,40;	      /*prepare to blank last line    */
	 asm  rep stosw;	      /*execute blank		      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga40a2;	      /*loop if lines still to scroll */
	 break;
      case 2:			      /*B&W 80x25		      */
      case 3:			      /*Color 80x25		      */
	 asm  mov ax,page;	      /*AX=page 		      */
	 asm  mov bx,256;	      /*BX=(page size)/16	      */
	 asm  mul bx;		      /*AX=(page offset)/16	      */
	 asm  mov dx,0b800h;	      /*DX=cga adapter base	      */
	 asm  add ax,dx;	      /*AX=page base		      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
	 asm  sub cx,24;	      /*CX=lines to scroll	      */
      cga80a2:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,160;	      /*point si to line 1	      */
	 asm  xor di,di;	      /*point di to line 0	      */
      cga80b2:
	 asm  cli;		      /*no interrupts		      */
      cga80c2:
	 asm  in al,dx; 	      /*get 6845 status 	      */
	 asm  test al,8;	      /*vertical retrace?	      */
	 asm  jnz cga80e2;	      /*long wait-access ok	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jc cga80c2;	      /*short wait-wait it out	      */
      cga80d2:
	 asm  in al,dx; 	      /*get 6845 status again	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jc cga80d2;	      /*wait for retrace	      */
      cga80e2:
	 asm  movsw;
	 asm  sti;		      /*allow interrupts	      */
	 asm  cmp si,4000;	      /*end of screen?		      */
	 asm  jne cga80b2;	      /*no - continue scroll	      */
	 asm  mov cl,020h;	      /*load ' ' for last line	      */
	 asm  mov ch,lattr;	      /*load attr for last line       */
      cga80f2:
	 asm  cli;		      /*no interrupts		      */
      cga80g2:
	 asm  in al,dx; 	      /*get 6845 status 	      */
	 asm  test al,8;	      /*vertical retrace?	      */
	 asm  jnz cga80i2;	      /*long wait-access ok	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jc cga80g2;	      /*short wait-wait it out	      */
      cga80h2:
	 asm  in al,dx; 	      /*get 6845 status again	      */
	 asm  rcr al,1; 	      /*horizontal retrace?	      */
	 asm  jnc cga80h2;	      /*wait for retrace	      */
      cga80i2:
	 asm  mov ax,cx;	      /*get blanking word	      */
	 asm  stosw;		      /*and then to screen	      */
	 asm  sti;		      /*allow interrupts	      */
	 asm  cmp di,4000;	      /*end of screen?		      */
	 asm  jne cga80f2;	      /*no - continue blanking	      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga80a2;	      /*loop if lines still to scroll */
	 break;
      case 4:			      /*B&W 40x25 graphics	      */
      case 5:			      /*Color 40x25 graphics	      */
	 asm  mov ax,0b800h;	      /*DX=cga adapter base	      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
	 asm  sub cx,24;	      /*CX=lines to scroll	      */
      cga320a2:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,320;
	 asm  xor di,di;
	 asm  mov cx,24;
      cga320b2:
	 asm  push cx;
	 asm  mov cx,160;
	 asm  rep movsw;
	 asm  add di,7872;
	 asm  add si,7872;
	 asm  mov cx,160;
	 asm  rep movsw;
	 asm  sub di,8192;
	 asm  sub si,8192;
	 asm  pop cx;
	 asm  loop cga320b2;
	 asm  mov al,lattr;
	 asm  shr al,1;
	 asm  shr al,1;
	 asm  shr al,1;
	 asm  shr al,1;
	 asm  and al,03h;
	 asm  mov cx,8;
      cga320c2:
	 asm  shl bx,1;
	 asm  shl bx,1;
	 asm  or bl,al;
	 asm  loop cga320c2;
	 asm  mov ax,bx;
	 asm  mov cx,160;
	 asm  rep stosw;
	 asm  add di,7872;
	 asm  mov cx,160;
	 asm  rep stosw;
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga320a2;	      /*loop if lines still to scroll */
	 break;
      case 6:			      /*B&W 80x25 graphics	      */
	 asm  mov ax,0b800h;	      /*DX=cga adapter base	      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
	 asm  sub cx,24;	      /*CX=lines to scroll	      */
      cga640a2:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,320;	      /*point si to line 1	      */
	 asm  xor di,di;	      /*point di to line 0	      */
	 asm  mov cx,24;	      /*lines to move		      */
      cga640b2: 		      /*beginning of loop	      */
	 asm  push cx;		      /*save loop count 	      */
	 asm  mov cx,160;	      /*CX=words to move	      */
	 asm  rep movsw;	      /*move words		      */
	 asm  add di,7872;
	 asm  add si,7872;
	 asm  mov cx,160;	      /*CX=words to move	      */
	 asm  rep movsw;	      /*move words		      */
	 asm  sub di,8192;
	 asm  sub si,8192;
	 asm  pop cx;		      /*restore loop count	      */
	 asm  loop cga640b2;	      /*end of loop		      */
	 asm  xor ax,ax;	      /*AX=blanking word	      */
	 asm  mov cx,160;	      /*words to blank		      */
	 asm  rep stosw;	      /*blank last line 	      */
	 asm  add di,7872;
	 asm  mov cx,160;	      /*words to blank		      */
	 asm  rep stosw;	      /*blank last line 	      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop cga640a2;	      /*loop if lines still to scroll */
	 break;
      case 7:
	 asm  mov ax,page;	      /*AX=page 		      */
	 asm  mov bx,256;	      /*BX=(page size)/16	      */
	 asm  mul bx;		      /*AX=(page offset)/16	      */
	 asm  mov dx,0b000h;	      /*DX=cga adapter base	      */
	 asm  add ax,dx;	      /*AX=page base		      */
	 asm  mov es,ax;	      /*ES=AX			      */
	 asm  mov ds,ax;	      /*DS=AX			      */
	 asm  mov cx,new_y;	      /*CX=current row		      */
	 asm  sub cx,24;	      /*CX=lines to scroll	      */
      mon80a2:
	 asm  push cx;		      /*save loop duration	      */
	 asm  mov si,160;	      /*point si to line 1	      */
	 asm  xor di,di;	      /*point di to line 0	      */
	 asm  mov cx,1920;	      /*words to move		      */
	 asm  rep movsw;	      /*move the words		      */
	 asm  mov al,020h;	      /*load ' ' for last line	      */
	 asm  mov ah,lattr;	      /*load attr for last line       */
	 asm  mov cx,80;	      /*words to clear		      */
	 asm  rep stosw;	      /*clear the words 	      */
	 asm  pop cx;		      /*restore loop duration	      */
	 asm  loop mon80a2;	      /*loop if lines still to scroll */
	 break;
	 }
      new_y = 24;
      asm  pop di;		      /*restore current di	      */
      asm  pop es;		      /*restore current es	      */
      asm  pop si;		      /*restore current si	      */
      asm  pop ds;		      /*restore current ds	      */
      }
   _BH = page;
   _DH = new_y;
   _DL = new_x;
   _AH = 2;
   geninterrupt(0x10);
   return(0);
   }
