//: ERROR.CPP -- The variable argument list for terminate() is
//. implemented using the ANSI C library functions for variable
//. arguments (in stdarg.h) and the associated printf()-like
//. vfprintf() function.  Note this demonstrates that you can
//. still use ANSI C library I/O with C++ (and any other ANSI C
//. library functions).
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>  // exit()
#include "error.h"

void error_handler::message(char * format_string, ...) {
  va_list arg_pointer;
  va_start(arg_pointer, format_string);
  fprintf(stderr, "%s error: ", msg);  // class message first
  vfprintf(stderr, format_string, arg_pointer);
  va_end(arg_pointer);
}

void error_handler::terminate(char * format_string, ...) {
  va_list arg_pointer;
  va_start(arg_pointer, format_string);
  fprintf(stderr, "%s error: ", msg);  // class message first
  vfprintf(stderr, format_string, arg_pointer);
  va_end(arg_pointer);
  exit(1);
}
