//: IOSTEST.CPP -- test of ioserror
//. Demonstrates that errors from all classes are always
//. reported, whether terminate is used or exit() is called.
#include "ioserror.h"
#include <stdlib.h>
#include <conio.h>  // getch()

class gonk {
  static ioserror error;
public:
  void test() {
    error << "oops! number: " << 47 << nl;
  }
};

class boink {
  static ioserror error;
public:
  void test() {
    error << "ack! value: " << 3.14159 << nl;
  }
};

class urp {
public:
  friend ostream& operator<<(ostream& os, urp&) {
    return os << "Urp!" << nl;
  }  // not a member function!!
};

// static data member definitions:
ioserror gonk::error("gonk");
ioserror boink::error("boink");

// global error function:
ioserror error("errstest");

void quit_test(int index) {
  cout << "early exit: press ESC" << endl;
  if(getch() == 27)
    error << "quitting on index " << index
	    << nl << terminate;
}

main() {
  gonk g;
  boink b;
  urp u;
  quit_test(1);
  g.test();
  quit_test(2);
  b.test();
  quit_test(3);
  error << u;  // urp's overloaded operator <<
  cout << "preparing to exit()" << endl;
}
