//: IOSERROR.H -- Simple error handler using iostreams.
//. Installing static objects of this class in other classes
//. and in programs puts a framework in place, which can be
//. modified later and recompiled for more sophisticated
//. error handling.
#ifndef IOSERROR_H_
#define IOSERROR_H_
#include <iostream.h>
#include <strstream.h>

// Manipulator inserts a newline in the output stream:
inline ostream& nl(ostream& os) { return os << "\n"; }

class ioserror : public ostrstream {
  enum { bsize = 300 };  // a "local const" for the class
  char msg[bsize];  // buffer for holding error messages
  char* classname;  // name associated with this handler
public:
  ioserror(char * class_name);  // name of the class
  void dump() {
    if(*msg) {  // only dump if there are messages
      clog << nl << classname << " error: " << msg << endl;
    }
  }
};

// Manipulator prints all error messages and exits:
ostream& terminate(ostream& os);

#endif // IOSERROR_H_
