//: IOSERROR.CPP -- implementation of iostream error handler
#include "ioserror.h"
#include <stdlib.h>
#pragma warn -inl  // ignore "not expanded inline" messages

// This is a trivial implementation; for general solutions you
// will probably want to use one which doesn't have a fixed size.
class eh_list {  // ioserror container class
  enum { size = 100 };  // number of error handlers
  static ioserror* list[size];
  static int cursor;
public:
  eh_list() {
    atexit(eh_list::dump);  // execute dump() on exit()
  }
  // Add error handlers as they are constructed:
  static void Register(ioserror* eh) {
    if(cursor < size)
      list[cursor++] = eh;
    else
      clog << "increase eh_list size" << nl;
  }
  // Dump contents of all error handlers:
  static void dump() {
    while(cursor-- > 0)
      list[cursor]->dump();
  }
};

// static data member definitions (initialize everything to 0)
ioserror* eh_list::list[eh_list::size] = { 0 };
int eh_list::cursor = 0;

static eh_list ehandler_list;  // visible only in this file

// Initialize the ostrstream to write to the msg buffer,
// and register this object in the eh_list:
ioserror::ioserror(char * class_name)
  : ostrstream(msg, bsize), classname(class_name) {
    eh_list::Register(this);  // static member function call
}

// The first error handler to terminate dumps the data
// from all the error handlers. No error information is lost.
ostream& terminate(ostream& os) { // manipulator
  exit(1);
  return os;  // dummy return value to satisfy compiler
}
