/*

	pcwin.cpp
	7-30-91
	Text windowing class

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include <pcwin.hpp>


void TextScreenState::save()
{
	struct text_info ti;

	gettextinfo(&ti);
	ol = ti.winleft; ot = ti.wintop;
	or = ti.winright; ob = ti.winbottom;
	ox = ti.curx; oy = ti.cury;
	oattr = ti.attribute;
	owscroll = _wscroll;
	odirectvideo = directvideo;
	cursor.saveOrig();
}

void TextScreenState::restore()
{
	::window(ol,ot,or,ob);
	_wscroll = owscroll;
	directvideo = odirectvideo;
	gotoxy(ox,oy);
	cursor.restoreOrig();
	textattr(oattr);
}



Palette TextWindow::defaultP = {

	0,  /*  monochrome         or         color  */

	svideo(DARKGRAY,LIGHTGRAY),	svideo(LIGHTRED,LIGHTGRAY),
	svideo(WHITE,LIGHTGRAY),	svideo(BLACK,LIGHTGRAY),
	svideo(WHITE,LIGHTGRAY),	svideo(BLACK,LIGHTGRAY),
	svideo(DARKGRAY,BLACK),		svideo(CYAN,BLUE),
	svideo(BLACK,LIGHTGRAY),	svideo(BLUE,LIGHTGRAY),
	svideo(WHITE,LIGHTGRAY),	svideo(LIGHTGRAY,RED),
	svideo(WHITE,BLACK),		svideo(WHITE,BLUE)
};

int TextWindow::dbuf[MAX_TW_DBUF];


void TextWindow::dressing(const unsigned char *msg, int d)
{
	if (!openned) return;
	int mlen = 0;
	if (msg) while (msg[mlen] && mlen < MAX_TW_DBUF)
		mlen++;
	int w = r - l - 1;
	if (mlen > w)
		mlen = w;
	int y, mattr;
	switch (d)  {
	case 1:
		y = t;
		mattr = mapattr(TITLE);
		break;
	case 2:
		y = b - (statusLine? 1 : 0);
		mattr = mapattr(FOOTER);
		break;
	case 3:
		if (!statusLine) return;
		y = b - 1;
		mattr = mapattr(STATUS);
		break;
	default:
		return;
	}
	mattr <<= 8;
	int i;
	switch (d)  {
	case 1:
	case 2:
		int fattr = mapattr(FRAME);
		fattr <<= 8;
		unsigned char ch = PCF.bxChar(bs,
			TxtFrmg::HORIZ);
		for (i = 0; i < w; i++)
			dbuf[i] = fattr | ch;
		int j = (w - mlen)/2;
		for (i = 0; i < mlen; i++, j++)
			dbuf[j] = mattr | msg[i];
		break;
	case 3:
		for (i = 0; i < mlen; i++)
			dbuf[i] = mattr | msg[i];
		while (i < w)
			dbuf[i++] = mattr
				| (unsigned char )' ';
		break;
	}
	puttext(l+1,y,l+w,y,dbuf);
}


int TextWindow::window(int left, int top, int right,
	int bottom, enum BSTYLE bs, int statusLine,
	int saveShadow, int castShadow)
{
	struct text_info ti;

	if (openned) return 0;
	if (bs >= NO_FRAME)
		return 0;
	this->castShadow = castShadow;
	if (saveShadow && castShadow)  {
		right++;
		bottom++;
	}
	if (!PCF.validateDimensions(left,top,right,bottom,4,
		statusLine?5:4)) return 0;
	if (saveShadow)  {
		if ((buf = new char[(right-left+1)
			*(bottom-top+1)*2]) == (char *)0)
			return 0;
		else if (!gettext(left,top,right,bottom,buf))
			return 0;
		if (castShadow)  {
			right--;
			bottom--;
		}
	}
	prevTxtScrState.save();
	mappalette(P);
	this->bs = bs;
	this->statusLine = statusLine;
	PCF.box(l=left,t=top,r=right,b=bottom,
		mapattr(FRAME),bs);
	::window(l+1,t+1,r-1,b-(statusLine?2:1));
	if (saveShadow && castShadow)  {
		putvideo(left+1,bottom+1,right+1,bottom+1,
			svideo(DARKGRAY,BLACK),dbuf);
		putvideo(right+1,top+1,right+1,bottom,
			svideo(DARKGRAY,BLACK),dbuf);
	}
	if (statusLine)
		dressing((const unsigned char *)"",3);
	mapvideo(NORMAL);
	clrscr();
	cursor.normal();
	return (openned = 1);
}


void TextWindow::close()
{
	if (openned)  {
		if (buf)  {
			int i = castShadow? 1 : 0;
			puttext(l,t,r+i,b+i,buf);
			delete buf;
			buf = (char *)0;
		}
		prevTxtScrState.restore();
		openned = 0;
	}
}

