/* sincos.h: */
/*   sine and cosine tables   use: sintbl[] = sin  * 256 */
/*   there are 360 entries for each table */

#ifndef _SINCOS_H
#define _SINCOS_H

#define NUM 256
#define NUMB 8

int sintbl[]={   /* sine table */
        0,     5,     9,    14,    18,    23,    27,    32,    36,    41,
       45,    49,    54,    58,    62,    67,    71,    75,    80,    84,
       88,    92,    96,   101,   105,   109,   113,   117,   121,   125,
      129,   132,   136,   140,   144,   147,   151,   155,   158,   162,
      165,   168,   172,   175,   178,   182,   185,   188,   191,   194,
      197,   199,   202,   205,   208,   210,   213,   215,   218,   220,
      222,   224,   227,   229,   231,   233,   234,   236,   238,   239,
      241,   243,   244,   245,   247,   248,   249,   250,   251,   252,
      253,   253,   254,   255,   255,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,   255,   255,   254,   253,
      253,   252,   251,   250,   249,   248,   247,   245,   244,   243,
      241,   239,   238,   236,   234,   233,   231,   229,   227,   224,
      222,   220,   218,   215,   213,   210,   208,   205,   202,   199,
      197,   194,   191,   188,   185,   182,   178,   175,   172,   168,
      165,   162,   158,   155,   151,   147,   144,   140,   136,   132,
      128,   125,   121,   117,   113,   109,   105,   101,    96,    92,
       88,    84,    80,    75,    71,    67,    62,    58,    54,    49,
       45,    41,    36,    32,    27,    23,    18,    14,     9,     5,
        0,    -4,    -8,   -13,   -17,   -22,   -26,   -31,   -35,   -40,
      -44,   -48,   -53,   -57,   -61,   -66,   -70,   -74,   -79,   -83,
      -87,   -91,   -95,  -100,  -104,  -108,  -112,  -116,  -120,  -124,
     -128,  -131,  -135,  -139,  -143,  -146,  -150,  -154,  -157,  -161,
     -164,  -167,  -171,  -174,  -177,  -181,  -184,  -187,  -190,  -193,
     -196,  -198,  -201,  -204,  -207,  -209,  -212,  -214,  -217,  -219,
     -221,  -223,  -226,  -228,  -230,  -232,  -233,  -235,  -237,  -238,
     -240,  -242,  -243,  -244,  -246,  -247,  -248,  -249,  -250,  -251,
     -252,  -252,  -253,  -254,  -254,  -255,  -255,  -255,  -255,  -255,
     -256,  -255,  -255,  -255,  -255,  -255,  -254,  -254,  -253,  -252,
     -252,  -251,  -250,  -249,  -248,  -247,  -246,  -244,  -243,  -242,
     -240,  -238,  -237,  -235,  -233,  -232,  -230,  -228,  -226,  -223,
     -221,  -219,  -217,  -214,  -212,  -209,  -207,  -204,  -201,  -198,
     -196,  -193,  -190,  -187,  -184,  -181,  -177,  -174,  -171,  -167,
     -164,  -161,  -157,  -154,  -150,  -146,  -143,  -139,  -135,  -131,
     -127,  -124,  -120,  -116,  -112,  -108,  -104,  -100,   -95,   -91,
      -87,   -83,   -79,   -74,   -70,   -66,   -61,   -57,   -53,   -48,
      -44,   -40,   -35,   -31,   -26,   -22,   -17,   -13,    -8,    -4,
}; /* end sintbl */

int costbl[]={   /* cosine table */
      256,   256,   256,   256,   256,   256,   255,   255,   254,   253,
      253,   252,   251,   250,   249,   248,   247,   245,   244,   243,
      241,   239,   238,   236,   234,   233,   231,   229,   227,   224,
      222,   220,   218,   215,   213,   210,   208,   205,   202,   199,
      197,   194,   191,   188,   185,   182,   178,   175,   172,   168,
      165,   162,   158,   155,   151,   147,   144,   140,   136,   132,
      128,   125,   121,   117,   113,   109,   105,   101,    96,    92,
       88,    84,    80,    75,    71,    67,    62,    58,    54,    49,
       45,    41,    36,    32,    27,    23,    18,    14,     9,     5,
        0,    -4,    -8,   -13,   -17,   -22,   -26,   -31,   -35,   -40,
      -44,   -48,   -53,   -57,   -61,   -66,   -70,   -74,   -79,   -83,
      -87,   -91,   -95,  -100,  -104,  -108,  -112,  -116,  -120,  -124,
     -128,  -131,  -135,  -139,  -143,  -146,  -150,  -154,  -157,  -161,
     -164,  -167,  -171,  -174,  -177,  -181,  -184,  -187,  -190,  -193,
     -196,  -198,  -201,  -204,  -207,  -209,  -212,  -214,  -217,  -219,
     -221,  -223,  -226,  -228,  -230,  -232,  -233,  -235,  -237,  -238,
     -240,  -242,  -243,  -244,  -246,  -247,  -248,  -249,  -250,  -251,
     -252,  -252,  -253,  -254,  -254,  -255,  -255,  -255,  -255,  -255,
     -256,  -255,  -255,  -255,  -255,  -255,  -254,  -254,  -253,  -252,
     -252,  -251,  -250,  -249,  -248,  -247,  -246,  -244,  -243,  -242,
     -240,  -238,  -237,  -235,  -233,  -232,  -230,  -228,  -226,  -223,
     -221,  -219,  -217,  -214,  -212,  -209,  -207,  -204,  -201,  -198,
     -196,  -193,  -190,  -187,  -184,  -181,  -177,  -174,  -171,  -167,
     -164,  -161,  -157,  -154,  -150,  -146,  -143,  -139,  -135,  -131,
     -127,  -124,  -120,  -116,  -112,  -108,  -104,  -100,   -95,   -91,
      -87,   -83,   -79,   -74,   -70,   -66,   -61,   -57,   -53,   -48,
      -44,   -40,   -35,   -31,   -26,   -22,   -17,   -13,    -8,    -4,
        1,     5,     9,    14,    18,    23,    27,    32,    36,    41,
       45,    49,    54,    58,    62,    67,    71,    75,    80,    84,
       88,    92,    96,   101,   105,   109,   113,   117,   121,   125,
      129,   132,   136,   140,   144,   147,   151,   155,   158,   162,
      165,   168,   172,   175,   178,   182,   185,   188,   191,   194,
      197,   199,   202,   205,   208,   210,   213,   215,   218,   220,
      222,   224,   227,   229,   231,   233,   234,   236,   238,   239,
      241,   243,   244,   245,   247,   248,   249,   250,   251,   252,
      253,   253,   254,   255,   255,   256,   256,   256,   256,   256,
}; /* end costbl */

#endif
