/*-------------------------------------------------------------------------
 *   dumpq.c - Delete all the jobs in a specified Netware print queue
 *             from the command line
 *
 *    by Glenn Scott (UCLA HUP / Info Services)
 *       Internet:  glenn@lands.sscnet.ucla.edu
 *       CIS:       71620,1521
 *
 *   10/18/91
 *
 *   Syntax:  DUMPQ queuename
 *
 *            Obviously, you have to have the proper rights to delete
 *            a bunch of jobs from a queue.
 *
 *   Recompilation requires Netware C Interface for DOS, v1.2
 *
 *   Notes:  This program deletes all the jobs in the queue that were
 *           present when the queue job list is retrieved.  In other
 *           words, jobs could be added while DUMPQ is deleting
 *           which would be missed, and jobs could print and thus
 *           leave the queue before DUMPQ can actually delete them.
 *
 */


#include <stdio.h>
#include <nit.h>
#include <niterror.h>

main( int argc, char *argv[] )
{
  void usage();
  int  rc;
  long queueID;
  WORD numJobs;
  WORD jobList[250];
  int  i;
  int  numDel = 0;

  printf("DUMPQ Queue Dump Utility\n");

  if ( !GetDefaultConnectionID() )
     {
     printf("This program requires Netware 2.1x or higher.\n");
     exit(1);
     }


  if ( argc < 2 ) {
     usage();
     exit(1);
     }


  if ( rc = GetBinderyObjectID( argv[1], OT_PRINT_QUEUE, &queueID ) != SUCCESSFUL ) {
     printf( "Error getting print queue object ID (%d)\n", rc );
     exit(1);
     }

  if ( rc = GetQueueJobList( queueID, &numJobs, jobList, 250 ) != SUCCESSFUL ) {
     printf( "Error getting job list (%d)\n", rc );
     exit(1);
     }

  if ( numJobs <= 0 ) {
     printf( "No jobs in queue %s to delete!\n", argv[1] );
     exit(0);
     }

  printf( "Deleting %d job(s) from queue %s...\n", numJobs, argv[1] );

  for ( i = 0; i < numJobs; i++ )
     if ( RemoveJobFromQueue( queueID, jobList[i] ) == SUCCESSFUL )
        numDel++;

  printf( "%d job(s) deleted from queue %s.\n", numDel, argv[1] );
  exit(0);
}

void usage()
{
  printf("Deletes jobs from a specified print queue.\n\n");
  printf("\tUsage:  dumpq printQueue\n\n");
  printf("Ex:  dumpq BILL_LASERJET\n");
}
