#include <alloc.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include "dtga.h"
#include "palette.h"
#include "tetra.h"
#include "gamma.h"
#include "igamma.h"
#include "gif.h"
#include "tga.h"
#include "fixed.h"

#define PRIME  2111
int ERR = 20;
int nMinPixels = 50;
int GrayFactor = 100;

static BYTE Mask[] = {0xff,0xfe,0xfc,0xf8,0xf0};
static BYTE rMask;
static BYTE gMask;
static BYTE bMask;

int rBits = 3;
int gBits = 2;
int bBits = 3;
int wRed = 2;
int wGreen = 3;
int wBlue = 1;
int Fixed = 0;

typedef struct
{
  BYTE rgb[3];
  BYTE Count[3];
  WORD Next;
} RGB;

typedef struct
{
  BYTE Count[3];
  WORD Error;
  WORD pColors;
} PART;

static RGB far *pRgb;
static int LastTetra;
int kNextRgb;

static WORD far *pRgbHash;
static PART far *pPart;

/* inline asm for 3 byte math operations */

#pragma warn -rvl
static void IncNumColor(BYTE far *nColor)
{
     asm les bx, nColor;
     asm mov ax, 1;
     asm add ES:[bx],ax;
     asm adc ES:[bx +2], ah;
}

static void ZeroNumColor(BYTE far *nColor)
{
     asm les bx, nColor;
     asm xor ax, ax;
     asm mov ES:[bx],ax;
     asm mov ES:[bx +2], ah;
}

static void AddNumColor(BYTE far *DesColor,BYTE far *SrcColor)
{
     asm les bx, SrcColor;
     asm mov ax, ES:[bx];
     asm mov dl, ES:[bx +2];
     asm les bx, DesColor;
     asm add ES:[bx],ax;
     asm adc ES:[bx +2], dl;
}

static long getNumColor(BYTE far *nColor)
{
     asm les bx, nColor;
     asm mov ax, ES:[bx];
     asm mov dl, ES:[bx +2];
     asm xor dh,dh;
}


#pragma warn +rvl

static WORD FindSplitEdge(WORD p,WORD *Edge)
{
    ITETRA far *pTetra;
    WORD error,vmax,Gray;
    int j,k,temp,ck,cj;
    WORD vEdge[2], maskj, maskk;

    pTetra = pTetraList[p];
    if( pTetra->Next[0] != 0) return(0);
    vmax = 0;

    for(k = 0, maskk = 0x0001; k < 3; k++, maskk <<= 1)
    {
        if( !(pTetra->Flags & maskk))
            continue;
        for(j = k +1, maskj = 1 << j; j < 4; j++, maskj <<= 1)
        {
           if( !(pTetra->Flags & maskj))
               continue;

           ck = 4*pTetra->DIndex[k];
           cj = 4*pTetra->DIndex[j];
           error = 0;
           temp = (int) DitherColorTable[ck++] - (int) DitherColorTable[cj++];
           if( temp < 0) temp = -temp;
           error = wRed*temp;
           temp = (int) DitherColorTable[ck++] - (int) DitherColorTable[cj++];
           if( temp < 0) temp = -temp;
           error += wGreen*temp;
           temp = (int) DitherColorTable[ck++] - (int) DitherColorTable[cj++];
           if( temp < 0) temp = -temp;
           error += wBlue*temp;

           ck = 4*pTetra->DIndex[k];
           cj = 4*pTetra->DIndex[j];
           temp = (DitherColorTable[ck++] + DitherColorTable[cj++]) >> 5;
           if( temp < 0) temp = -temp;
           Gray = wRed*temp;
           temp = (DitherColorTable[ck++] + DitherColorTable[cj++]) >> 5;
           if( temp < 0) temp = -temp;
           Gray += wGreen*temp;
           temp = (DitherColorTable[ck++] + DitherColorTable[cj++]) >> 5;
           if( temp < 0) temp = -temp;
           Gray += wBlue*temp;
           Gray = Gray/(wRed + wGreen + wBlue);

           if(Gray <= 32) temp = 8;
           else if(Gray  <= 64) temp = 5;
           else if(Gray  <= 128) temp = 4;
           else if(Gray  <= 192) temp = 3;
           else if(Gray  <= 224) temp = 2;
           else temp = 1;

           temp = Scale(temp,GrayFactor,100);
           if( temp < 1) temp = 1;

           error = (error/(wRed + wGreen + wBlue)) >> 4;
           error = temp*error;

           if( error > vmax)
           {
              vmax = error;
              vEdge[0] = pTetra->DIndex[k];
              vEdge[1] = pTetra->DIndex[j];
           }

        }

    }
    Edge[0] = vEdge[0];
    Edge[1] = vEdge[1];

    if( vmax < ERR )  vmax = 0;

    return(vmax);
}


static void  SortRgbByTetra(void)
{
   int k,j;
   WORD rgb[3],p,q[4],c0,mask;
   int test[3];
   ITETRA far *pTetra;
   WORD Edge[2];
   for( k = MAXRGB; k > kNextRgb; k--)
   {
      rgb[0] = pRgb[k].rgb[0] << 4;
      rgb[1] = pRgb[k].rgb[1] << 4;
      rgb[2] = pRgb[k].rgb[2] << 4;

      p = getPrimaryTetrahedron(rgb);
      pTetra = pTetraList[p];
      while( (p != 0 ) && (pTetra->Next[0] != 0) )
      {
          p = SelectTetra(p,rgb);
          if( p == 0) break;
          pTetra = pTetraList[p];
      }

      c0 = 4*pTetra->DIndex[0];

      for(j = 0; j < 3; j++)
          test[j] =   (int) rgb[j] - (int) DitherColorTable[c0++];
      q[3] = DotP(test,pTetra->W3,pTetra->V3W3);
      if(q[3] > PCut)
          pTetra->Flags |= V3_USED;
      q[2] = DotP(test,pTetra->W2,pTetra->V2W2);
      if(q[2] > PCut)
          pTetra->Flags |= V2_USED;
      q[1] = DotP(test,pTetra->W1,pTetra->V1W1);
      if(q[1] > PCut)
          pTetra->Flags |= V1_USED;
      q[0] = 512 - q[1] - q[2] - q[3];
         if(q[0] > PCut)
          pTetra->Flags |= V0_USED;

      if( pPart[p].Error == 0)  pPart[p].Error  =  FindSplitEdge(p,Edge);
      pRgb[k].Next = pPart[p].pColors;
      pPart[p].pColors = k;
      AddNumColor(pPart[p].Count,pRgb[k].Count);
   }

   /* init color used flags */
   for(k = MAXTETRA; k > kNextTetra; k--)
   {
       if(pPart[k].pColors == 0) continue;
       pTetra = pTetraList[k];
       if(pTetra->Next[0] != 0) continue;
       mask = 0x0001;
       for(j = 0; j < 4; j++)
       {
          if( pTetra->Flags & mask)
              DitherColorTable[4*pTetra->DIndex[j] + 3]++;
          mask <<= 1;
       }
   }

}

static int NumActualColors(int nColors)
{
   int k,Num;

   for(k = 0, Num = 0; k < nColors; k++)
   {
      if(DitherColorTable[4*k + 3] > 0) Num++;
   }
   return(Num);
}

static void  SortRgb(void)
{

   int k,j, test[3];
   WORD rgb[3],p,pNext,pNew,c0;
   ITETRA far *pTetra;
   WORD Edge[2], mask,q[4];

   for( k = MAXTETRA; k > kNextTetra; k--)
   {
      if( pPart[k].pColors == 0) continue;
      pTetra = pTetraList[k];
      if(pTetra->Next[0] == 0) continue;
      for(j = 0, mask = 0x0001; j < 4; j++, mask <<= 1)
      {
          if( pTetra->Flags & mask)
             DitherColorTable[4*pTetra->DIndex[j] + 3]--;
      }
      p = pPart[k].pColors;
      while(p != 0)
      {
          rgb[0] = pRgb[p].rgb[0] << 4;
          rgb[1] = pRgb[p].rgb[1] << 4;
          rgb[2] = pRgb[p].rgb[2] << 4;
          pNext =  pRgb[p].Next;
          pNew = SelectTetra(k,rgb);
          pRgb[p].Next = pPart[pNew].pColors;
          pPart[pNew].pColors = p;
          pTetra = pTetraList[pNew];

          c0 = 4*pTetra->DIndex[0];
          for(j = 0; j < 3; j++)
              test[j] =   (int) rgb[j] - (int) DitherColorTable[c0++];
          q[3] = DotP(test,pTetra->W3,pTetra->V3W3);
          if(q[3] > PCut)
              pTetra->Flags |= V3_USED;
          q[2] = DotP(test,pTetra->W2,pTetra->V2W2);
          if(q[2] > PCut)
              pTetra->Flags |= V2_USED;
          q[1] = DotP(test,pTetra->W1,pTetra->V1W1);
          if(q[1] > PCut)
              pTetra->Flags |= V1_USED;
          q[0] = 512 - q[1] - q[2] - q[3];
          if(q[0] > PCut)
              pTetra->Flags |= V0_USED;


          if( pPart[pNew].Error == 0)
               pPart[pNew].Error  =  FindSplitEdge(pNew,Edge);

          AddNumColor(pPart[pNew].Count,pRgb[p].Count);
          p = pNext;
      }
      pPart[k].pColors = 0;
      ZeroNumColor(pPart[k].Count);
      pPart[k].Error = 0;
   }

   /* init color used flags */
   for(k = LastTetra; k > kNextTetra; k--)
   {
       if(pPart[k].pColors == 0) continue;
       pTetra = pTetraList[k];
       if(pTetra->Next[0] != 0) continue;
       for(j = 0, mask = 0x0001; j < 4; j++, mask <<= 1)
       {
          if( pTetra->Flags & mask)
              DitherColorTable[4*pTetra->DIndex[j] + 3]++;
       }
   }
}

static void ColorLog(int nDitherColors)
{
   FILE *log;
   int k,j,n,rgb[3];
   log = fopen("test.log","w");
   if ( log == NULL) return;

   for(k = 0; k < nDitherColors; k++)
   {
       for( j = 0; j < 3; j++)
       rgb[j] = (DitherColorTable[4*k + j] + 8) >> 4;
       n = DitherColorTable[4*k + 3];
       fprintf(log,"\n [%3d]  (%3d,%3d,%3d)  n = %3d",k,rgb[0],rgb[1],rgb[2],n);
   }
   fclose(log);
}

static int InitColorMapping(int nColors)
{
  int Index;
  int k,j;

   for(k = 0, Index = 0; k < DITHERSIZE; k++)
   {
       if(Index < nColors)
       {
           if( DitherColorTable[4*k +3] == 0)
               DitherColorTable[4*k +3] = 256;
           else
           {
                for( j = 0; j < 3; j++)
                   ActualColors[3*Index + j] = DitherColorTable[4*k + j];
               DitherColorTable[4*k +3] = Index++;
           }
       }
       else
          DitherColorTable[4*k +3] = 256;

   }

   nActualColors = Index;

   for(k = 0; k < DITHERSIZE; k++)
   {
       if( DitherColorTable[4*k +3] == 256)
           DitherColorTable[4*k +3] = ClipColor(&DitherColorTable[4*k]);
   }
   return(Index);

}



static int CheckPixel(BYTE far *rgb)
{
   long Hash;
   WORD index,p;

   rgb[0] = rMask & rgb[0];
   rgb[1] = gMask & rgb[1];
   rgb[2] = bMask & rgb[2];
   Hash = rgb[0] >> rBits;
   Hash <<= 8 - gBits;
   Hash |= rgb[1] >> gBits;
   Hash <<= 8 - bBits;
   Hash |= rgb[2] >> bBits;
   index = Hash % PRIME;
   p = pRgbHash[index];
   while(p != 0)
   {
      if(  (pRgb[p].rgb[0] == rgb[0])
         && (pRgb[p].rgb[1] == rgb[1])
         && (pRgb[p].rgb[2] == rgb[2]))
      {
          IncNumColor(pRgb[p].Count);
          return(0);
      }
      p = pRgb[p].Next;
   }
   /* not in list, add */
   if(kNextRgb < 1) return(1);
   p = kNextRgb--;
   pRgb[p].rgb[0] = rgb[0];
   pRgb[p].rgb[1] = rgb[1];
   pRgb[p].rgb[2] = rgb[2];
   IncNumColor(pRgb[p].Count);
   pRgb[p].Next = pRgbHash[index];
   pRgbHash[index] = p;
   return(0);
}


int CreatPalette(int nColors)
{
    BYTE far *pPixel;
    WORD Edge[2];
    BYTE rgb[4];
    int k,Height,Width,j,nDitherColors,vTetra;
    long vmax,temp;
    int nAct;
    nDitherColors = 64;
    pPart = (PART far *) calloc((MAXTETRA +1),sizeof(PART));
    if( pPart == NULL)  return(0);
    pRgbHash = (WORD far *) calloc(PRIME,sizeof(WORD));
    if( pRgbHash == NULL)  return(0);
    pRgb = (RGB far *) calloc((MAXRGB+1),sizeof(RGB));
    if( pRgb == NULL)  return(0);
    kNextRgb = MAXRGB;
    Height = TgaImageInfo.Height;
    Width  = TgaImageInfo.Width;
    for( k = Height; k > 0; k--)
    {
       pPixel = pTgaLine();
       if( pPixel == NULL) return(0);

       for( j = Width; j >= 0; j--, pPixel += 3)
       {
          rgb[0] = InverseGammaCorrection[pPixel[2]];
          rgb[1] = InverseGammaCorrection[pPixel[1]];
          rgb[2] = InverseGammaCorrection[pPixel[0]];
          CheckPixel(rgb);
       }
    }
    SortRgbByTetra();
    printf("Generating Palette.\n");
    nAct = NumActualColors(nDitherColors);
    while( nAct < nColors )
    {
        LastTetra = kNextTetra;
        vmax = 0;
        vTetra = 0;
        for(k = MAXTETRA; k > kNextTetra; k--)
        {
             temp = getNumColor(pPart[k].Count);
             if( temp < nMinPixels) continue;
             temp = pPart[k].Error;
             if(temp > vmax )
             {
                vmax = temp;
                vTetra = k;
             }
        }
        if( vTetra == 0)
        {
           if( nMinPixels <= 1) break;
           nMinPixels = 1;
           nAct = NumActualColors(nDitherColors);
           continue;
        }

        if( !FindSplitEdge(vTetra,Edge) )
        {
           ZeroNumColor(pPart[vTetra].Count);
           pPart[vTetra].pColors = 0;
           nAct = NumActualColors(nDitherColors);
           continue;
        }
        if(AddDitherColor(nDitherColors++,Edge) < 0) return(0);
        SortRgb();
        if( nDitherColors >= DITHERSIZE) break;
        nAct = NumActualColors(nDitherColors);
#ifdef TEST
        printf("\n nDitherColors = %3d, nAct = %3d",nDitherColors,nAct);
#endif
    }
#ifdef TEST
        printf("\n");
        ColorLog(nDitherColors);
#endif
    free(pPart);
    free(pRgb);
    free(pRgbHash);
    nDitherColors = InitColorMapping(NumActualColors(nDitherColors));
    nActualColors = nDitherColors;
    printf("Converting Image.\n");

    if(ResetTgaFile()) return(0);
    return(nDitherColors);
}

int CalculatePalette(int nColors)
{
   int k, nDitherColors;

   if(InitRootTetrahedrons() ) return(0);
   nDitherColors = 64;


   if(Fixed)
       nDitherColors = FixedPalette(nColors);
   else
   {
       rMask = Mask[rBits];
       gMask = Mask[gBits];
       bMask = Mask[bBits];
       nDitherColors = CreatPalette(nColors);
   }
   if( nDitherColors < 64) return(0);

   for(k = 0; k < nDitherColors; k++)
   {
       ColorTable[3*k] = GammaCorrection[(ActualColors[3*k] + 8) >> 4 ];
       ColorTable[3*k +1] = 
                  GammaCorrection[(ActualColors[3*k +1] + 8) >> 4 ];
       ColorTable[3*k +2] =
                  GammaCorrection[(ActualColors[3*k +2] + 8) >> 4 ];
   }
   if( nDitherColors > 128) return(8);
   if( nDitherColors > 64) return(7);
   return(6);
}








