/* gamma.c */
#include "gamma.h"



unsigned char GammaCorrection[256]; /* gamma correction table */

/* gamma 1.5 */
static unsigned char G15[256] = {
  0,  6, 10, 13, 16, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39,
 40, 42, 44, 45, 47, 48, 50, 51, 53, 54, 56, 57, 58, 60, 61, 63,
 64, 65, 67, 68, 69, 70, 72, 73, 74, 75, 77, 78, 79, 80, 81, 83,
 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99,100,
101,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,
118,119,120,121,122,123,124,125,125,126,127,128,129,130,131,132,
133,134,135,136,137,138,138,139,140,141,142,143,144,145,146,146,
147,148,149,150,151,152,153,153,154,155,156,157,158,159,159,160,
161,162,163,164,164,165,166,167,168,169,169,170,171,172,173,173,
174,175,176,177,177,178,179,180,181,181,182,183,184,185,185,186,
187,188,188,189,190,191,192,192,193,194,195,195,196,197,198,198,
199,200,201,201,202,203,204,204,205,206,207,207,208,209,210,210,
211,212,213,213,214,215,215,216,217,218,218,219,220,220,221,222,
223,223,224,225,225,226,227,228,228,229,230,230,231,232,232,233,
234,235,235,236,237,237,238,239,239,240,241,241,242,243,244,244,
245,246,246,247,248,248,249,250,250,251,252,252,253,254,254,255};

/* gamma 2.0 */
static unsigned char G20[256] = {
  0, 16, 23, 28, 32, 36, 39, 42, 45, 48, 50, 53, 55, 58, 60, 62,
 64, 66, 68, 70, 71, 73, 75, 77, 78, 80, 81, 83, 84, 86, 87, 89,
 90, 92, 93, 94, 96, 97, 98,100,101,102,103,105,106,107,108,109,
111,112,113,114,115,116,117,118,119,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,135,136,137,138,139,140,141,142,
143,144,145,145,146,147,148,149,150,151,151,152,153,154,155,156,
156,157,158,159,160,160,161,162,163,164,164,165,166,167,167,168,
169,170,170,171,172,173,173,174,175,176,176,177,178,179,179,180,
181,181,182,183,183,184,185,186,186,187,188,188,189,190,190,191,
192,192,193,194,194,195,196,196,197,198,198,199,199,200,201,201,
202,203,203,204,204,205,206,206,207,208,208,209,209,210,211,211,
212,212,213,214,214,215,215,216,217,217,218,218,219,220,220,221,
221,222,222,223,224,224,225,225,226,226,227,228,228,229,229,230,
230,231,231,232,233,233,234,234,235,235,236,236,237,237,238,238,
239,240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,
247,248,248,249,249,250,250,251,251,252,252,253,253,254,254,255};

/* gamma 2.5 */
static unsigned char G25[256] = {
  0, 28, 37, 43, 48, 53, 57, 61, 64, 67, 70, 73, 75, 78, 80, 82,
 84, 86, 88, 90, 92, 94, 96, 97, 99,101,102,104,105,107,108,110,
111,113,114,115,117,118,119,120,122,123,124,125,126,127,129,130,
131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,
147,148,149,149,150,151,152,153,154,155,155,156,157,158,159,160,
160,161,162,163,164,164,165,166,167,167,168,169,170,170,171,172,
173,173,174,175,175,176,177,177,178,179,179,180,181,182,182,183,
183,184,185,185,186,187,187,188,189,189,190,190,191,192,192,193,
194,194,195,195,196,197,197,198,198,199,199,200,201,201,202,202,
203,203,204,205,205,206,206,207,207,208,208,209,209,210,211,211,
212,212,213,213,214,214,215,215,216,216,217,217,218,218,219,219,
220,220,221,221,222,222,223,223,224,224,225,225,226,226,227,227,
228,228,229,229,230,230,230,231,231,232,232,233,233,234,234,235,
235,235,236,236,237,237,238,238,239,239,240,240,240,241,241,242,
242,243,243,243,244,244,245,245,246,246,246,247,247,248,248,248,
249,249,250,250,251,251,251,252,252,253,253,253,254,254,255,255};

/* gamma 3.0 */
static unsigned char G30[256] = {
  0, 40, 51, 58, 64, 69, 73, 77, 80, 84, 87, 89, 92, 95, 97, 99,
101,103,105,107,109,111,113,114,116,118,119,121,122,124,125,126,
128,129,130,132,133,134,135,136,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,157,158,159,160,
161,162,163,163,164,165,166,167,167,168,169,170,170,171,172,173,
173,174,175,175,176,177,177,178,179,180,180,181,182,182,183,183,
184,185,185,186,187,187,188,188,189,190,190,191,191,192,193,193,
194,194,195,196,196,197,197,198,198,199,199,200,201,201,202,202,
203,203,204,204,205,205,206,206,207,207,208,208,209,209,210,210,
211,211,212,212,213,213,214,214,215,215,216,216,216,217,217,218,
218,219,219,220,220,221,221,221,222,222,223,223,224,224,224,225,
225,226,226,227,227,227,228,228,229,229,230,230,230,231,231,232,
232,232,233,233,234,234,234,235,235,236,236,236,237,237,237,238,
238,239,239,239,240,240,241,241,241,242,242,242,243,243,243,244,
244,245,245,245,246,246,246,247,247,247,248,248,249,249,249,250,
250,250,251,251,251,252,252,252,253,253,253,254,254,254,255,255};

/* returns the voltage value, given gamma and intensity I */
/* interpolates using the above tables */

static unsigned char GammaFunc(int gamma, int I)
{
   int k,dg,a,b;

   if( gamma > 30) gamma = 30;
   if( gamma < 10) gamma = 10;
   if(gamma == 10) return(I);
   if(gamma == 30) return(G30[I]);

   k = gamma/5;
   dg = gamma - 5*k;

   a = 2*dg;
   b = 10 -a;

   switch(k)
   {
      case 2: /* gamma 11 to 14 */
            return((a*G15[I] +b*I + 5)/10); 

      case 3: /* gamma 15 to 19 */
            return((a*G20[I] +b*G15[I] + 5)/10); 
  
      case 4: /* gamma 20 to 24 */
            return((a*G25[I] +b*G20[I] + 5)/10); 
  
      case 5: /* gamma 25 to 29 */
            return((a*G30[I] +b*G25[I] + 5)/10);    
   }
   return(I);
}

/* sets the GammaCorrection table */

void SetGamma(int gamma)
{
    int k;

    for(k = 0; k < 256; k++)
       GammaCorrection[k] = GammaFunc(gamma,k);

}



