/*********************************** floyd.c *********************************/


#include "dtga.h"
#include "floyd.h"
#include "tetra.h"
#include "igamma.h"


static CurY; 
static int MaxX = 1024;
static int MaxY = 1024;

/* floyd fill buffer */
int Line[3][1030][3];
unsigned char Colors[1030];

void InitFloydPic(void)
{

    CurY = 0;
    ClearRGBArray(Line[0][OFFSET],MaxX);
    ClearRGBArray(Line[1][OFFSET],MaxX);
}


unsigned char near *pFloydLine(unsigned char far *pixels,int linelen)
{
    int x2;
    int yi,yi1,x,color;
    int error;
    int near *pxy, near *pxy1;
    WORD near *pColor;
    BYTE far *pGColor;

    if( linelen == 0) return(0);
    if(CurY >= MaxY) return(0);
    x2 = linelen;
    if( x2 >= MaxX) x2 = MaxX;


    yi = 0x0001 & CurY;
    yi1 = 0x0001 ^ yi;
    if( yi == 0)
    {
         pGColor = pixels;
         for( x = 0; x < x2; x++)
         {
             pxy = Line[yi][x + OFFSET];
             pxy[2] =
                 Clip(pxy[2] +  (InverseGammaCorrection[*(pGColor++)] << 4) );
             pxy[1] =
                 Clip(pxy[1] +  (InverseGammaCorrection[*(pGColor++)] << 4) );
             pxy[0] =
                 Clip(pxy[0] +  (InverseGammaCorrection[*(pGColor++)] << 4) );

             Colors[x] = color = getFastColor((WORD far *) pxy);
             pxy1 =  Line[yi1][x + OFFSET];
             pColor = &ActualColors[(color << 1) + color];
             error =*pxy - (int)  *(pColor++);
             ForwardError(pxy++,pxy1++,error);
             error =*pxy - (int)  *(pColor++);
             ForwardError(pxy++,pxy1++,error);
             error =*pxy - (int)  *(pColor++);
             ForwardError(pxy,pxy1,error);
         }
     }
     else
     {
         pGColor = &pixels[3*x2 -1];
         for( x = x2 -1; x >= 0; x--)
         {
             pxy = Line[yi][x + OFFSET];
             pxy[0] =
                 Clip(pxy[0] +  (InverseGammaCorrection[*(pGColor--)] << 4));
             pxy[1] =
                 Clip(pxy[1] +  (InverseGammaCorrection[*(pGColor--)] << 4));
             pxy[2] =
                 Clip(pxy[2] +  (InverseGammaCorrection[*(pGColor--)] << 4));
             Colors[x] = color = getFastColor((WORD far *) pxy);
             pxy1 =  Line[yi1][x + OFFSET];
             pColor = &ActualColors[(color << 1) + color];
             error =*pxy - (int) *(pColor++);
             ReverseError(pxy++,pxy1++,error);
             error =*pxy - (int) *(pColor++);
             ReverseError(pxy++,pxy1++,error);
             error =*pxy - (int) *(pColor++);
             ReverseError(pxy,pxy1,error);

         }
     }
     ClearRGBArray(Line[yi][OFFSET],x2);

   CurY++;
   return(Colors);
}






