#include <alloc.h>
#include <stdio.h>

#include "dtga.h"
#include "tetra.h"
#include "fixed.h"
#include "palette.h"


typedef struct
{
  WORD Error;

} PART;

PART far *pPart;



static void AddCenters(void)
{
  int Cube,Index;
  ITETRA far *pTetra;
  WORD Edge[2];

  Index = 64;

  for( Cube = 0; Cube < 27; Cube++)
  {
      pTetra = pTetraList[RGBCube[Cube][0]];
      Edge[0] = pTetra->DIndex[0];
      Edge[1] = pTetra->DIndex[1];
      AddDitherColor(Index++,Edge);
  }

}



static WORD FindSplitEdge(WORD p,WORD *Edge)
{
    ITETRA far *pTetra;
    WORD error,vmax,Gray;
    int j,k,temp,ck,cj;
    WORD vEdge[2];

    pTetra = pTetraList[p];
    if( pTetra->Next[0] != 0) return(0);
    vmax = 0;
    for(k = 0; k < 3; k++)
    {
        for(j = k +1; j < 4; j++)
        {
           ck = 4*pTetra->DIndex[k];
           cj = 4*pTetra->DIndex[j];
           error = 0;
           temp = (int) DitherColorTable[ck++] - (int) DitherColorTable[cj++];
           if( temp < 0) temp = -temp;
           error = wRed*temp;
           temp = (int) DitherColorTable[ck++] - (int) DitherColorTable[cj++];
           if( temp < 0) temp = -temp;
           error += wGreen*temp;
           temp = (int) DitherColorTable[ck++] - (int) DitherColorTable[cj++];
           if( temp < 0) temp = -temp;
           error += wBlue*temp;


           ck = 4*pTetra->DIndex[k];
           cj = 4*pTetra->DIndex[j];

           temp = (DitherColorTable[ck++] + DitherColorTable[cj++]) >> 5;
           if( temp < 0) temp = -temp;
           Gray = wRed*temp;
           temp = (DitherColorTable[ck++] + DitherColorTable[cj++]) >> 5;
           if( temp < 0) temp = -temp;
           Gray += wGreen*temp;
           temp = (DitherColorTable[ck++] + DitherColorTable[cj++]) >> 5;
           if( temp < 0) temp = -temp;
           Gray += wBlue*temp;
           Gray = Gray/(wRed + wGreen + wBlue);

           if(Gray <= 8) temp = 16;
           else if(Gray <= 16) temp = 12;
           else if(Gray <= 32) temp = 8;
           else if(Gray  <= 64) temp = 5;
           else if(Gray  <= 128) temp = 4;
           else if(Gray  <= 192) temp = 3;
           else if(Gray  <= 224) temp = 2;
           else temp = 1;

           temp = Scale(temp,GrayFactor,100);
           if( temp < 1) temp = 1;

           error = (error/(wRed + wGreen + wBlue)) >> 4;
           error = temp*error;


           if( error > vmax)
           {
              vmax = error;
              vEdge[0] = pTetra->DIndex[k];
              vEdge[1] = pTetra->DIndex[j];
           }

        }

    }
    Edge[0] = vEdge[0];
    Edge[1] = vEdge[1];

    if( vmax < ERR )  vmax = 0;

    return(vmax);
}

static int LastTetra;

static void  SortRgbByTetra(void)
{
   int k;
   WORD Edge[2];

   ITETRA far *pTetra;

   for( k = MAXTETRA; k > kNextTetra; k--)
   {
  
      pTetra = pTetraList[k];
      if(pTetra->Next[0] != 0) continue;
      pPart[k].Error = FindSplitEdge(k,Edge);
   }
   LastTetra = kNextTetra;
}

static void  SortRgb(void)
{

   int k;
   ITETRA far *pTetra;
   WORD Edge[2];

   for( k = LastTetra; k > kNextTetra; k--)
   {
      pTetra = pTetraList[k];
      if(pTetra->Next[0] != 0) continue;
      pPart[k].Error = FindSplitEdge(k,Edge);
   }
   LastTetra = kNextTetra;
}

int FixedPalette(int nColors)
{
    WORD Edge[2];
    int k,nDitherColors,vTetra,j;
    long vmax;
    ITETRA far *pTetra;
    pPart = (PART far *) calloc((MAXTETRA +1),sizeof(PART));
    if( pPart == NULL)  return(0);
    AddCenters();
    nDitherColors = 64 + 27;

    SortRgbByTetra();
    printf("Generating Palette.\n");

    while(nDitherColors < nColors)
    {
        vmax = 0;
        vTetra = 0;
        for(k = MAXTETRA; k > kNextTetra; k--)
        {
             pTetra = pTetraList[k];
             if( pTetra->Next[0] != 0) continue;
             if(pPart[k].Error > vmax )
             {
                vmax = pPart[k].Error;
                vTetra = k;
             }
        }
        if( vTetra == 0) break;
        FindSplitEdge(vTetra,Edge);
        if(AddDitherColor(nDitherColors++,Edge) < 0) return(0);
        SortRgb();
    }


    for(k = MAXTETRA; k > kNextTetra; k--)
    {
        pTetra = pTetraList[k];
        if(pTetra->Next[0] != 0) continue;
        pTetra->Flags = 0x0f;

     }

     for(k = 0; k < nDitherColors; k++)
     {
           DitherColorTable[4*k +3] = k;

            for( j = 0; j < 3; j++)
               ActualColors[3*k + j] = DitherColorTable[4*k + j];
     }

    free(pPart);
    printf("Converting Image.\n");      
    return(nDitherColors);
}








