/********************************** tga.c ************************************/


#include "dtga.h"
#include <io.h>
#include <stdio.h>
#include <alloc.h>
#include "tga.h"

#define MAXBUFSIZE 65520 

int hTga;  /* targa file handle */


CMAPSPEC TgaColorMapInfo;
IMAGESPEC TgaImageInfo;




static long PicOffset;
static BYTE far *pInputBuffer;
static BYTE far *pInputLine;
static WORD nInputBuffer;
static WORD nLinesPerStrip;
static WORD nBytesPerLine;
static int nLinesLeft;
static int nStripLines;




int ReadStrip(void)
{
   long offset;
   WORD nBytes;

   printf("%3d\b\b\b",nLinesLeft);
   if( nLinesLeft < 1) return(1);

   if(TgaImageInfo.Descriptor & 0x20)
    { /* top left */
       if(nLinesLeft > nLinesPerStrip)
       {
           if(read(hTga,pInputBuffer,nInputBuffer) != nInputBuffer) return(1);
           nStripLines = nLinesPerStrip;
       }
       else
       {
           nBytes = nLinesLeft*nBytesPerLine;
           if(read(hTga,pInputBuffer,nBytes) != nBytes) return(1);
           nStripLines = nLinesLeft;
       }
       pInputLine = pInputBuffer;
    }
    else
    { /* lower left */

       if(nLinesLeft > nLinesPerStrip)
       {
           offset  = PicOffset;
           offset +=  (long) (nLinesLeft - nLinesPerStrip)*nBytesPerLine;
           lseek(hTga,offset,SEEK_SET);
           if(read(hTga,pInputBuffer,nInputBuffer) != nInputBuffer) return(1);
           nStripLines = nLinesPerStrip;

       }
       else
       {
           nBytes = nLinesLeft*nBytesPerLine;
           lseek(hTga,PicOffset,SEEK_SET);
           if(read(hTga,pInputBuffer,nBytes) != nBytes) return(1);
           nStripLines = nLinesLeft;
       }
       pInputLine = pInputBuffer + (long) (nStripLines -1)*nBytesPerLine;

    }
    nLinesLeft -= nLinesPerStrip;
    return(0);
}


int ReadTgaInfo(void)
{

   unsigned char Buffer[256];

   if(read(hTga,Buffer,3) != 3) return(1);


   if( Buffer[2] != 2)  return(1);
   if( Buffer[1] != 0)  return(1);

   if(read(hTga,&TgaColorMapInfo,sizeof(CMAPSPEC) ) != sizeof(CMAPSPEC))
       return(1);

   if(read(hTga,&TgaImageInfo,sizeof(IMAGESPEC) ) != sizeof(IMAGESPEC))
       return(1);


    if(Buffer[0] != 0) read(hTga,Buffer,Buffer[0]);

    if( TgaImageInfo.PixelSize != 24 ) return(1);

    /* tga ok, set up to read pixels */
    PicOffset = tell(hTga);
    nBytesPerLine = 3*TgaImageInfo.Width;
    nLinesPerStrip = MAXBUFSIZE/nBytesPerLine;
    nInputBuffer = nBytesPerLine*nLinesPerStrip;
    pInputBuffer = malloc(nInputBuffer);
    if(pInputBuffer == NULL) return(1);
    nLinesLeft = TgaImageInfo.Height;
    return(ReadStrip());
}

int ResetTgaFile(void)
{
    lseek(hTga,PicOffset,SEEK_SET);
    nLinesLeft = TgaImageInfo.Height;
    return(ReadStrip());
}

BYTE far *pTgaLine(void)
{
    BYTE far *pLine;

    if(nStripLines < 1)
    {
       if(ReadStrip()) return(NULL);
    }

    nStripLines--;    
    pLine = pInputLine;
    if(TgaImageInfo.Descriptor & 0x20)
        pInputLine += nBytesPerLine;
    else
        pInputLine -= nBytesPerLine;
    return(pLine);
}




