#include <alloc.h>
#include <mem.h>
#include <dos.h>
#include "dtga.h"
#include "gramschm.h"
#include "tetra.h"



/* shift up 4 bits before using */

WORD nActualColors;
WORD ActualColors[3*256];

#ifdef TEST
WORD tmaxerror = 0;
WORD tcolorerror[3] ={0,0,0};
#endif

WORD  DitherColorTable[4*DITHERSIZE] = {
/* [  0] */  0,  0,  0,  0,
/* [  1] */  0,  0, 85,  0,
/* [  2] */  0, 85,  0,  0,
/* [  3] */  0, 85, 85,  0,
/* [  4] */ 85,  0,  0,  0,
/* [  5] */ 85,  0, 85,  0,
/* [  6] */ 85, 85,  0,  0,
/* [  7] */ 85, 85, 85,  0,
/* [  8] */  0,  0,170,  0,
/* [  9] */  0, 85,170,  0,
/* [ 10] */ 85,  0,170,  0,
/* [ 11] */ 85, 85,170,  0,
/* [ 12] */  0,  0,255,  0,
/* [ 13] */  0, 85,255,  0,
/* [ 14] */ 85,  0,255,  0,
/* [ 15] */ 85, 85,255,  0,
/* [ 16] */  0,170,  0,  0,
/* [ 17] */  0,170, 85,  0,
/* [ 18] */ 85,170,  0,  0,
/* [ 19] */ 85,170, 85,  0,
/* [ 20] */  0,170,170,  0,
/* [ 21] */ 85,170,170,  0,
/* [ 22] */  0,170,255,  0,
/* [ 23] */ 85,170,255,  0,
/* [ 24] */  0,255,  0,  0,
/* [ 25] */  0,255, 85,  0,
/* [ 26] */ 85,255,  0,  0,
/* [ 27] */ 85,255, 85,  0,
/* [ 28] */  0,255,170,  0,
/* [ 29] */ 85,255,170,  0,
/* [ 30] */  0,255,255,  0,
/* [ 31] */ 85,255,255,  0,
/* [ 32] */170,  0,  0,  0,
/* [ 33] */170,  0, 85,  0,
/* [ 34] */170, 85,  0,  0,
/* [ 35] */170, 85, 85,  0,
/* [ 36] */170,  0,170,  0,
/* [ 37] */170, 85,170,  0,
/* [ 38] */170,  0,255,  0,
/* [ 39] */170, 85,255,  0,
/* [ 40] */170,170,  0,  0,
/* [ 41] */170,170, 85,  0,
/* [ 42] */170,170,170,  0,
/* [ 43] */170,170,255,  0,
/* [ 44] */170,255,  0,  0,
/* [ 45] */170,255, 85,  0,
/* [ 46] */170,255,170,  0,
/* [ 47] */170,255,255,  0,
/* [ 48] */255,  0,  0,  0,
/* [ 49] */255,  0, 85,  0,
/* [ 50] */255, 85,  0,  0,
/* [ 51] */255, 85, 85,  0,
/* [ 52] */255,  0,170,  0,
/* [ 53] */255, 85,170,  0,
/* [ 54] */255,  0,255,  0,
/* [ 55] */255, 85,255,  0,
/* [ 56] */255,170,  0,  0,
/* [ 57] */255,170, 85,  0,
/* [ 58] */255,170,170,  0,
/* [ 59] */255,170,255,  0,
/* [ 60] */255,255,  0,  0,
/* [ 61] */255,255, 85,  0,
/* [ 62] */255,255,170,  0,
/* [ 63] */255,255,255,  0};


ITETRA far **pTetraList;
int   kNextTetra;



WORD RGBCube[27][6];
static BYTE far *pLookupBuffer;
static BYTE far *pLookup;
static BYTE far *pClipBuffer;
static BYTE far *pClip;

static int   Sides[6] = {0,4080,0,4080,0,4080};


/* color vertexes for the six root tetrahedrons */
/* each subcube is split into 6 tetrahrons */

BYTE TetraColors[6][4] = {
0,7,1,3,   /* tetra 0 */
0,7,2,3,   /* tetra 1 */
0,7,4,5,   /* tetra 2 */
0,7,4,6,   /* tetra 3 */
0,7,1,5,   /* tetra 4 */
0,7,2,6};  /* tetra 5 */



int ClipColor(WORD far *rgb)
{
   int k,minv,mink,temp,sum,j;

   minv = 0x7fff;
   mink = -1;
   for(k = 0; k < nActualColors; k++)
   {
       sum = 0;
       for( j = 0; j < 3; j++)
       {
          temp = (int) ActualColors[3*k +j] - (int) rgb[j];
          if( temp < 0) temp = -temp;
          sum += temp;
       }
       if( sum < minv)
       {
          minv = sum;
          mink = k;
       }
   }
  return(mink);
}


int FindVertexColor(int kCube,int kTetra,int kVertex)
{
     int temp, rgb[3],k;
     k = TetraColors[kTetra][kVertex];

     if(kCube == 0) return(k);

     rgb[0] = DitherColorTable[4*k];
     rgb[1] = DitherColorTable[4*k +1];
     rgb[2] = DitherColorTable[4*k +2];

     temp = kCube/9;
     rgb[0] += CUBESIZE*temp;
     kCube = kCube - 9*temp;
     temp = kCube/3;
     rgb[1] += CUBESIZE*temp;
     kCube = kCube - 3*temp;
     rgb[2] += CUBESIZE*kCube;
     for( k = 0; k < 64; k++)
     {
        if( rgb[0] != DitherColorTable[4*k] ) continue;
        if( rgb[1] != DitherColorTable[4*k +1] ) continue;
        if( rgb[2] != DitherColorTable[4*k +2] ) continue;
        return(k);
     }
     return(-1);
}

/* returns the tetrahedron */
/*  tetra = TetraDecode[closest face][next closest face] */

int TetraDecode[6][6] = {  /* closest face */
-1,-1, 0, 1, 1, 0,        /* red = 0 */
-1,-1, 2, 3, 3, 2,        /* red = 1.0 */
 4, 2,-1,-1, 2, 4,        /* green = 0 */
 1, 5,-1,-1, 5, 1,        /* green = 1.0 */
 5, 3, 3, 5,-1,-1,        /* blue = 0 */
 0, 4, 4, 0,-1,-1};       /* blue = 1.0 */




/*
int DotP(int far *rgb,int far *W,int VW)
{
  long vw;
  int Dot
   vw =  (long) rgb[0]*W[0]
        + (long) rgb[1]*W[1]
        + (long) rgb[2]*W[2];
   Dot =  (vw/VW);
   return(Dot);
}
*/

int DotP(int far *rgb,int far *W,int VW)
{

    asm les bx,rgb;
    asm mov ax, es:[bx];
    asm les bx,W;
    asm imul word ptr es:[bx];
    asm mov si,ax;
    asm mov di,dx;
    asm mov ax, es:[bx +2];
    asm les bx,rgb;
    asm imul word ptr es:[bx +2];
    asm add si,ax;
    asm adc di,dx;
    asm mov ax, es:[bx +4];
    asm les bx,W;
    asm imul word ptr es:[bx +4];
    asm add ax,si;
    asm adc dx,di;
    asm idiv word ptr VW;
    return(_AX);
}


int InitColorLookup(void)
{
    WORD Seg;

    pLookupBuffer =  farmalloc(65552);
    if(pLookupBuffer == NULL) return(1);
    Seg = FP_SEG(pLookupBuffer) +1;
    pLookup = MK_FP(Seg,0);
    _fmemset(pLookup,255,0xffff);
    pLookup[0xffff] = 255;

    pClipBuffer = farmalloc( (1 << 13) + 16);
    if(pClipBuffer == NULL) return(1);
    Seg = FP_SEG(pClipBuffer) + 1;
    pClip = MK_FP(Seg,0);
    _fmemset(pClip,255, 1 << 13);
    return(0);
}



int getFastColor(WORD far *rgb)
{
   WORD Index;
   WORD NearColor;
   BYTE ClipMask;
   WORD ClipIndex;
   WORD fClip;
   if(NoFast)
   {
        NearColor = getNearColor(rgb);
        if( NearColor > 255)
        {  // clip
             NearColor &= 0x00ff;
             rgb[0] = ActualColors[3*NearColor];
             rgb[1] = ActualColors[3*NearColor +1];
             rgb[2] = ActualColors[3*NearColor +2];
        }
        return(NearColor);
   }

   Index = rgb[0] >> 7;
   Index |= (0xfc0 & rgb[1]) >> 1;
   Index |= (0xf80 & rgb[2]) << 4;

   NearColor = pLookup[Index];
   ClipIndex = Index >> 3;
   ClipMask = 0x80 >> (Index & 0x0007);
   fClip = 0;
   if(ClipMask & pClip[ClipIndex] )
   {
       fClip = 1;
   }

   if( (NearColor != 255) || !fClip )
   {
        if(fClip)
        {
             rgb[0] = ActualColors[3*NearColor];
             rgb[1] = ActualColors[3*NearColor +1];
             rgb[2] = ActualColors[3*NearColor +2];
        }
        return(NearColor);
   }
   rgb[0] = (rgb[0] & 0x0f80);
   rgb[1] = (rgb[1] & 0x0fc0);
   rgb[2] = (rgb[2] & 0x0fc0);

   NearColor = getNearColor(rgb);
   if(NearColor < 256)
   {
      pLookup[Index] = NearColor;
      pClip[ClipIndex] &= ~ClipMask;
   }
   else
   {
      NearColor = 0x00ff & NearColor;
      pLookup[Index] = NearColor;
      pClip[ClipIndex] |= ClipMask; // should be set already
      rgb[0] = ActualColors[3*NearColor];
      rgb[1] = ActualColors[3*NearColor +1];
      rgb[2] = ActualColors[3*NearColor +2];
   }
   return(NearColor);
}


int getPrimaryTetrahedron(WORD far *rgb)
{
    int k,kmin,j,jmin,distance,temp;
    int RGB[3],Cube;

   /* find the cube and scale rgb values */
   temp = rgb[2]/CUBESIZE;
   if( temp > 2 ) temp = 2;
   Cube = temp;
   RGB[2] = 3*( (int) rgb[2] - CUBESIZE*temp);

   temp = rgb[1]/CUBESIZE;
   if( temp > 2 ) temp = 2;
   Cube += 3*temp;
   RGB[1] = 3*( (int) rgb[1] - CUBESIZE*temp);

   temp = rgb[0]/CUBESIZE;
   if( temp > 2 ) temp = 2;
   Cube += 9*temp;
   RGB[0] = 3*( (int) rgb[0] - CUBESIZE*temp);


    distance = 0x7fff;
    kmin = -1;
    /* find closeest side */

    for( k = 0; k < 6; k++)
    {
        temp = Sides[k] -  RGB[k >> 1];
        if( temp < 0) temp = -temp;
        if( temp < distance)
        {
           distance = temp;
           kmin = k;
        }
    }

    /* find next closest side */
    distance = 0x7fff;
    jmin = -1;
    for( j = 0; j < 6; j++)
    {
        if ( (j/2) == (kmin/2) ) continue;
        temp = Sides[j] -  RGB[j >> 1];
        if( temp < 0) temp = -temp;
        if( temp < distance)
        {
           distance = temp;
           jmin = j;
        }
    }

    temp = TetraDecode[kmin][jmin];
    temp = RGBCube[Cube][temp];
    return(temp);
}



WORD SelectTetra(WORD TetraIndex,WORD far *rgb)
{

    ITETRA far *pTetra;
    int q[4],test[3],k,c0;
    int t0,t1;


    pTetra = pTetraList[TetraIndex];
    if(pTetra->Next[0] == 0)  return(0);

    c0 = 4*pTetra->DIndex[0];

    for(k = 0; k < 3; k++)
       test[k] =   (int) rgb[k] - (int) DitherColorTable[c0++];

    q[3] = DotP(test,pTetra->W3,pTetra->V3W3);
    q[2] = DotP(test,pTetra->W2,pTetra->V2W2);
    q[1] = DotP(test,pTetra->W1,pTetra->V1W1);
    q[0] = 512 - q[1] - q[2] - q[3];




    t0 =   0x0003 & ((pTetra->Next[0]) >> 14);
    t1 =   0x0003 & ((pTetra->Next[1]) >> 14);
    if(q[t0] > q[t1]) return(0x3fff & pTetra->Next[1]);

    return(0x3fff & pTetra->Next[0]);
}



int getNearColor(WORD far *rgb)
{
   unsigned int p;
   int q[4],max;
   int test[3];
   int k,c0,j;
   int mmax,km;
   ITETRA far *pTetra;

    test[0] =  rgb[0];
    test[1] =  rgb[1];
    test[2] =  rgb[2];


    p = getPrimaryTetrahedron(rgb);
    pTetra = pTetraList[p];

    while( (p != 0 ) && (pTetra->Next[0] != 0) )
    {
       p = SelectTetra(p,(WORD *) test);
       if( p == 0)
           break;
       pTetra = pTetraList[p];
    }
    c0 = 4*pTetra->DIndex[0];
    for(k = 0; k < 3; k++)
      test[k] -=  (int) DitherColorTable[c0++];

    q[3] = DotP((int far  *) test,pTetra->W3,pTetra->V3W3);
    q[2] = DotP((int far  *) test,pTetra->W2,pTetra->V2W2);
    q[1] = DotP( (int far *) test,pTetra->W1,pTetra->V1W1);
    q[0] = 512 - q[1] - q[2] - q[3];

#ifdef TEST
    test[0] = test[1] = test[2] = 0;
    for(k = 0; k < 4; k++)
    {
       c0 = 4*pTetra->DIndex[k];
       for(j = 0; j < 3; j++)
       {
           test[j] += Scale(q[k],DitherColorTable[c0++],512);
       }
    }
    max = 0;
    for( k = 0; k < 3; k++)
    {
        j = rgb[k] - test[k];
        if ( j < 0) j = -j;
        max += j;
    }
    if( j > tmaxerror)
    {
        tmaxerror = j;
        tcolorerror[0] = test[0];
        tcolorerror[1] = test[1];
        tcolorerror[2] = test[2];
    }
#endif

    k = -1;
    max = 0;

      km = 0;
      mmax = q[0];
      if( q[1] > mmax)
      {
          km = 1;
          mmax = q[1];
      }
      if( q[2] > mmax)
      {
          km = 2;
          mmax = q[2];
      }
      if( q[3] > mmax)
      {
          km = 3;
          mmax = q[3];
      }

      if( (q[0] > max) && (pTetra->Flags && V0_USED) )
      {

         k = 0;
         max = q[0];
      }

      if( (q[1] > max) && (pTetra->Flags && V1_USED) )
      {
         k = 1;
         max = q[1];
      }

      if( (q[2] > max) && (pTetra->Flags && V2_USED) )
      {
         k = 2;
         max = q[2];
      }

      if( (q[3] > max)  && (pTetra->Flags && V3_USED) ) k = 3;

       if( k != km)
       {
           if( k < 0)
               return(0x0100 | DitherColorTable[4*pTetra->DIndex[km] +3]);
           else
               return(0x0100 | DitherColorTable[4*pTetra->DIndex[k] +3]);
       }
       else
           return(DitherColorTable[4*pTetra->DIndex[k] +3]);


}



static int SetTetrahedron(WORD *colors)
{
   int k;
   int v0[3],v1[3],v2[3],v3[3],w1[3],w2[3],w3[3];
   ITETRA far *pTetra;


   if(kNextTetra < 1)
   {
       return( -1);
   }
   pTetra = (ITETRA far *) calloc(1,sizeof(ITETRA));
   if( pTetra == NULL)
   {
       return(-1);
   }
   pTetraList[kNextTetra] = pTetra;

   pTetra->Flags = 0;
   pTetra->DIndex[0] = colors[0];
   pTetra->DIndex[1] = colors[1];
   pTetra->DIndex[2] = colors[2];
   pTetra->DIndex[3] = colors[3];

   pTetra->Next[0] = 0;
   pTetra->Next[1] = 0;



   for(k = 0; k < 3; k++)
   {
      v0[k] = DitherColorTable[4*colors[0] +k];
      v1[k] = DitherColorTable[4*colors[1] +k] - v0[k];
      v2[k] = DitherColorTable[4*colors[2] +k] - v0[k];
      v3[k] = DitherColorTable[4*colors[3] +k] - v0[k];
   }

     GramSchmidt(v2,v3,v1,w1);
     GramSchmidt(v1,v3,v2,w2);
     GramSchmidt(v1,v2,v3,w3);


     pTetra->V1W1 = ((long) v1[0]*w1[0] +(long) v1[1]*w1[1] + 
                    (long)v1[2]*w1[2] + 256) >> 9;

     if(pTetra->V1W1 == 0)  pTetra->V1W1 = 1;

     pTetra->V2W2 = ((long) v2[0]*w2[0] +(long) v2[1]*w2[1] +
                    (long)v2[2]*w2[2] + 256)>> 9;

     if(pTetra->V2W2 == 0)  pTetra->V2W2 = 1;

     pTetra->V3W3 = ((long) v3[0]*w3[0] +(long) v3[1]*w3[1] +
                     (long) v3[2]*w3[2] + 256)>> 9;

     if(pTetra->V3W3 == 0)  pTetra->V3W3 = 1;

     for(k = 0; k < 3; k++)
     {
         pTetra->W1[k] = w1[k];
         pTetra->W2[k] = w2[k];
         pTetra->W3[k] = w3[k];
     }

    return(kNextTetra--);
}

int InitRootTetrahedrons(void)
{
   int kCube, kTetra,k,j;
   WORD Colors[4];
   /* init terta list */
   pTetraList = (ITETRA far **) calloc(MAXTETRA +1,sizeof(ITETRA far *));
   if(pTetraList == NULL)
   {
       return(1);
   }
   kNextTetra = MAXTETRA;

   /* shift first 64 colors 4 bit to the left */
   /* shoud change */
   for(k = 4*64 -1; k >= 0; k--)  DitherColorTable[k] <<= 4;

   for(kCube = 0; kCube < 27; kCube++)
   {
       for(kTetra = 0; kTetra < 6; kTetra++)
       {
          for( k = 0; k < 4; k++)
              Colors[k] = FindVertexColor(kCube,kTetra,k);
          j = SetTetrahedron(Colors);
          if(j < 1)
          {
             return(1);  /* error */
          }
          RGBCube[kCube][kTetra] = j;
       }
   }
   return(0);
}


int  AddDitherColor(int CIndex, WORD far *Edge)
{

    if(SplitTetrahedronEdge(CIndex,Edge) < 0)
    {
       return(-1);
    }
    return(0);
}



/* finds the tetrahedron the encloses rgb */
/* splits it into sub tetrahedrons.  also splits adjacent tetrahedra if
   neccessary */

int SplitList[256];

int  SplitTetrahedronEdge(int CIndex, WORD far *Edge)
{
      WORD rgb[3];
      int nTetraSplit,k;

      for(k = 0; k < 3; k++)
      {
          rgb[k] = (  DitherColorTable[4*Edge[0] +k]
                   +  DitherColorTable[4*Edge[1] +k]) >> 1;
          DitherColorTable[4*CIndex + k] = rgb[k];
      }
      DitherColorTable[4*CIndex + 3] = 0;

      nTetraSplit = FindSplit(Edge);
      if( nTetraSplit < 1)
      {
          return(-1);
      }
      for(k = 0; k < nTetraSplit; k++)
      {
         if(PartitionTetra(SplitList[k],Edge,CIndex) != 2)
         {
            return(-1);
         }
      }
      return(0);
}


int FindSplit(WORD far *Edge)
{
   int k,nTetra,j,i,flag;
   WORD far *pColor;

   nTetra = 0;
   for( k = kNextTetra +1; k <= MAXTETRA; k++)
   {
      if(pTetraList[k]->Next[0] != 0) continue;
      pColor = pTetraList[k]->DIndex;
      for( i = 0; i < 2; i++)
      {
          flag = 0;
          for(j = 0; j < 4; j++)
          {
             if(Edge[i] == pColor[j])
             {
                flag = 1;
                break;
             }
          }
          if( flag == 0) break;
      }
      if( flag == 1)
      {
         if( nTetra > 255)
         {
             return(-1);
         }
         SplitList[nTetra++] = k;
      }
   }
   return(nTetra);
}


int  PartitionTetra(WORD TetraIndex,WORD far *Edge,int CIndex)
{
    ITETRA far *pTetra;
    int n1,n0;
    WORD c[4],m[4];
    int k,j,index;

    pTetra = pTetraList[TetraIndex];

    j = 0;
    n1 = -1;
    n0 = -1;
    for(k = 0; k < 4; k++)
    {
        index = pTetra->DIndex[k];
         if( (Edge[0] != index) && (Edge[1] != index ) )
             m[j++] = index;
         if(Edge[0] == index) n0 = k;
         if(Edge[1] == index) n1 = k;

    }
    if( j != 2)  return(-1);
    c[0] = CIndex;
    c[1] = m[0];
    c[2] = m[1];
    c[3] = Edge[1];

    k = SetTetrahedron(c);
    if( k < 1)
    {
        return(-1);
    }
    pTetra->Next[0] = k | (n0 << 14);

    c[3] = Edge[0];
    k = SetTetrahedron(c);
    if( k < 1)
    {
        return(-1);
    }
    pTetra->Next[1] = k | (n1 << 14);

    return(2);
}






