/*****************************************************************************
 *
 * GIFENCODE.C    - GIF Image compression interface
 *
 *
 *****************************************************************************/
/* modified 7/3/91, RMC */
#include "dtga.h"
#include <io.h>
#include "gif.h"

SCRDESC ScreenInfo;
IMAGEDESC ImageInfo;

BYTE ColorTable[3*256];

int hGif;


void EncodeGif(int GWidth, int GHeight,int Background, int BitsPerPixel)
{
   int ColorMapSize;
   int InitCodeSize;
   char B[2];
 
   if( BitsPerPixel <= 1 )
      InitCodeSize = 2;
   else
      InitCodeSize = BitsPerPixel;

   ScreenInfo.Width = GWidth;
   ScreenInfo.Height = GHeight;
   ScreenInfo.BgColor = Background;
   ScreenInfo.Zero = 0;
   ScreenInfo.Flags = 0x80 | (7 << 4)  | (BitsPerPixel - 1);


   ImageInfo.ImageSep = ',';
   ImageInfo.Left = 0;
   ImageInfo.Top = 0;
   ImageInfo.Width = GWidth;
   ImageInfo.Height = GHeight;
   ImageInfo.Flags = (BitsPerPixel - 1);
   ImageInfo.CodeSize = InitCodeSize;

   ColorMapSize = 1 << BitsPerPixel;


/* Write the Magic header */
   if( write(hGif,"GIF87a",6) != 6)
   {
      parse_error = 1;
      return;
   }

/*  Write out the screen info */
   if( write(hGif,&ScreenInfo,sizeof(SCRDESC)) != sizeof(SCRDESC))
   {
      parse_error = 1;
      return;
   }

/* Write out the Global Colour Map */

   if( write(hGif,ColorTable,3*ColorMapSize) != 3*ColorMapSize)
   {
      parse_error = 1;
      return;
   }

/*  Write an Image info */

   if( write(hGif,&ImageInfo,sizeof(IMAGEDESC)) != sizeof(IMAGEDESC))
   {
      parse_error = 1;
      return;
   }

/* Go and actually compress the data */
   compress( InitCodeSize+1);

   B[0] = 0;
   B[1] = ';';
   if( write(hGif,B,2) != 2)   parse_error = 1;
}
