/* tetra.h */
// #define TEST

#define MAXTETRA   4000
#define MAXCOLOR  4080
#define CUBESIZE   1360
#define DITHERSIZE 400

#define V0_USED  0x0001
#define V1_USED  0x0002
#define V2_USED  0x0004
#define V3_USED  0x0008


typedef struct 
{
   WORD Flags;
   WORD DIndex[4]; /* 4 color indexs that define the tetrahaedron */
   int W1[3];      
   int W2[3];
   int W3[3];
   int V1W1;   
   int V2W2;
   int V3W3;
   WORD Next[2]; /* top two bits specify the color not present in decendant */
} ITETRA;


extern ITETRA far **pTetraList;
/* max intensity (1.0) = 255 << 6 */

extern WORD RGBCube[27][6];


extern WORD  DitherColorTable[4*DITHERSIZE];
extern WORD nActualColors;
extern WORD  ActualColors[3*256];

extern int kNextTetra;

int getNearColor(WORD far *rgb);
int getFastColor(WORD far *rgb);
int getPrimaryTetrahedron(WORD far *rgb);

unsigned int SelectTetra(unsigned int TetraIndex,WORD far *rgb);
int InitColorLookup(void);
int InitRootTetrahedrons(void);
int  AddDitherColor(int CIndex, WORD far *Edge);
int FindSplit(WORD *far Edge);
int  PartitionTetra(WORD TetraIndex,WORD far *Edge,int CIndex);
int  SplitTetrahedronEdge(int CIndex,WORD far *Edge);
int DotP(int far *rgb,int far *W,int VW);
int ClipColor(WORD far *rgb);



#ifdef TEST
extern WORD tmaxerror;
extern WORD tcolorerror[3];
#endif