/* gamma.c */
#include "gamma.h"

int DarkLimit = 0;
int LiteLimit = 255;


unsigned char InverseGammaCorrection[256]; /* gamma correction table */



/* gamma = 1.5 */ 
static unsigned char InvG15[256] = {
  0,  0,  0,  0,  1,  1,  1,  1,  1,  2,  2,  2,  3,  3,  3,  4,
  4,  4,  5,  5,  6,  6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 11,
 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 17, 18, 18, 19, 20, 20,
 21, 21, 22, 23, 23, 24, 25, 26, 26, 27, 28, 28, 29, 30, 31, 31,
 32, 33, 34, 34, 35, 36, 37, 37, 38, 39, 40, 41, 41, 42, 43, 44,
 45, 46, 46, 47, 48, 49, 50, 51, 52, 53, 53, 54, 55, 56, 57, 58,
 59, 60, 61, 62, 63, 64, 65, 65, 66, 67, 68, 69, 70, 71, 72, 73,
 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 88, 89, 90,
 91, 92, 93, 94, 95, 96, 97, 98, 99,100,102,103,104,105,106,107,
108,109,110,112,113,114,115,116,117,119,120,121,122,123,124,126,
127,128,129,130,132,133,134,135,136,138,139,140,141,142,144,145,
146,147,149,150,151,152,154,155,156,158,159,160,161,163,164,165,
167,168,169,171,172,173,174,176,177,178,180,181,182,184,185,187,
188,189,191,192,193,195,196,197,199,200,202,203,204,206,207,209,
210,211,213,214,216,217,218,220,221,223,224,226,227,228,230,231,
233,234,236,237,239,240,242,243,245,246,248,249,251,252,254,255};

/* gamma = 2.0 */
static unsigned char InvG20[256] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,
  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,
  4,  4,  5,  5,  5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  8,  9,
  9,  9, 10, 10, 11, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16,
 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 23, 23, 24, 24,
 25, 26, 26, 27, 28, 28, 29, 30, 30, 31, 32, 32, 33, 34, 35, 35,
 36, 37, 38, 38, 39, 40, 41, 42, 42, 43, 44, 45, 46, 47, 47, 48,
 49, 50, 51, 52, 53, 54, 55, 56, 56, 57, 58, 59, 60, 61, 62, 63,
 64, 65, 66, 67, 68, 69, 70, 71, 73, 74, 75, 76, 77, 78, 79, 80,
 81, 82, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 95, 97, 98, 99,
100,102,103,104,105,107,108,109,111,112,113,115,116,117,119,120,
121,123,124,126,127,128,130,131,133,134,136,137,139,140,142,143,
145,146,148,149,151,152,154,155,157,158,160,162,163,165,166,168,
170,171,173,175,176,178,180,181,183,185,186,188,190,192,193,195,
197,199,200,202,204,206,207,209,211,213,215,217,218,220,222,224,
226,228,230,232,233,235,237,239,241,243,245,247,249,251,253,255};

/* gamma = 2.5 */
static unsigned char InvG25[256] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  4,  4,
  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,  8,
  8,  8,  9,  9,  9, 10, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14,
 14, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 22,
 22, 23, 23, 24, 25, 25, 26, 26, 27, 28, 28, 29, 30, 30, 31, 32,
 33, 33, 34, 35, 36, 36, 37, 38, 39, 40, 40, 41, 42, 43, 44, 45,
 46, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 72, 73, 75, 76, 77, 78,
 80, 81, 82, 83, 85, 86, 87, 89, 90, 91, 93, 94, 95, 97, 98, 99,
101,102,104,105,107,108,110,111,113,114,116,117,119,121,122,124,
125,127,129,130,132,134,135,137,139,141,142,144,146,148,150,151,
153,155,157,159,161,163,165,166,168,170,172,174,176,178,180,182,
184,186,189,191,193,195,197,199,201,204,206,208,210,212,215,217,
219,221,224,226,228,231,233,235,238,240,243,245,248,250,253,255,};

/* gamma = 3.0 */
static unsigned char InvG30[256] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,
  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  4,  4,
  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,  8,
  8,  8,  8,  9,  9,  9, 10, 10, 10, 11, 11, 12, 12, 12, 13, 13,
 14, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21,
 22, 22, 23, 23, 24, 25, 25, 26, 27, 27, 28, 29, 29, 30, 31, 32,
 32, 33, 34, 35, 35, 36, 37, 38, 39, 40, 40, 41, 42, 43, 44, 45,
 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 62,
 63, 64, 65, 67, 68, 69, 70, 72, 73, 74, 76, 77, 78, 80, 81, 82,
 84, 85, 87, 88, 90, 91, 93, 94, 96, 97, 99,101,102,104,105,107,
109,111,112,114,116,118,119,121,123,125,127,129,131,132,134,136,
138,140,142,144,147,149,151,153,155,157,159,162,164,166,168,171,
173,175,178,180,182,185,187,190,192,195,197,200,202,205,207,210,
213,215,218,221,223,226,229,232,235,237,240,243,246,249,252,255,};

/* returns the intensity value, given gamma and the dac voltage V */
/* interpolates using the above tables */

static unsigned char InvGamma(int gamma, int V)
{
   int k,dg,a,b;
   if( gamma > 30) gamma = 30;
   if( gamma < 10) gamma = 10;
   if(gamma == 10) return(V);
   if(gamma == 30) return(InvG30[V]);

   k = gamma/5;
   dg = gamma - 5*k;

   a = 2*dg;
   b = 10 -a;

   switch(k)
   {
      case 2: /* gamma 11 to 14 */
            return((a*InvG15[V] +b*V + 5)/10); 

      case 3: /* gamma 15 to 19 */
            return((a*InvG20[V] +b*InvG15[V] + 5)/10); 
  
      case 4: /* gamma 20 to 24 */
            return((a*InvG25[V] +b*InvG20[V] + 5)/10); 
  
      case 5: /* gamma 25 to 29 */
            return((a*InvG30[V] +b*InvG25[V] + 5)/10);    
   }
   return(V);
}

/* sets the InverseGammaCorrection table */

void SetInverseGamma(int gamma)
{
    int k,temp;
    int dc;
    dc = LiteLimit - DarkLimit;
    if( dc < 64)
    {
        for(k = 0; k < 256; k++)
           InverseGammaCorrection[k] = InvGamma(gamma,k);       
    }
    else
    {
        for(k = 0; k < 256; k++)
        {
           temp = InvGamma(gamma,k);
           if( temp < DarkLimit)
              temp = 0;
           else if ( temp > LiteLimit)
              temp = 255;
           else
              temp = (temp -DarkLimit)*255L/dc;
           InverseGammaCorrection[k] = temp;
        }

    }

}



