/********************************** dtga.c **********************************/
/*                          DTGA v3.0,   TGA to GIF File Conversion.        */
/*                             Last Change 11/20/91                         */
/****************************************************************************/

#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <string.h>
#include "dtga.h"
#include "gif.h"
#include "tga.h"
#include "gamma.h"
#include "igamma.h"
#include "floyd.h"
#include "tetra.h"
#include "palette.h"
#include "igamma.h"

int UnGamma = 10;
int GammaValue = 20;
int OptimizePalette = 256;
int NoFast = 0;
int PCut = 512/20;

int parse_error;




char *copyright = "DTGA v3.0  by Robert M. Crawford";

char *address = "1075 Elsie Mae Drive, Boulder Creek, California 95006";

char *syntax =
"Syntax is: dtga [options] src [des]";

char *options[] = {
"  -d       Disable fast color selection.",
"  -cd##    Set dark contrast limit, 0 - 64.",
"  -cl##    Set lite contrast limit, 191 - 255.",
"  -e###    Minimum Error, 8 to 50, default = 20.",
"  -f       Use Fixed Color Palette.",
"  -a###    Set color distibution, 50 to 400, default = 100.",
"  -m###    Set minimum pixel threshold to ###, default = 50 pixels.",
"  -n###    Maximum colors = ### (default = 256).",
"  -i##     Input gamma, gamma = ##/10, default is 1.0",
"  -o##     Output gamma, gamma = ##/10, default is 2.0.",
"  -r#      Red quantitization, ## = LSB's discarded, default is 3.",
"  -g#      Green quantitization, ## = LSB's discarded, default is 2.",
"  -b#      Blue quantitization, ## = LSB's discarded, default is 3.",
"  -p###    Clipping level, default is 5 percent.",
"  -w###    Red, Green, Blue color weighting, default is -w231.",
NULL};



int cdecl main(int argc, char *argv[])
{

   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char file[MAXFILE];
   char ext[MAXEXT];
   char s[MAXPATH];
   unsigned int partest;
   char *cpar;
   int k;
   int InitCodeSize;

   partest = 0;
   cpar = argv[partest + 1];

   printf("%s\n",copyright);
   printf("%s\n\n",address);

   /* check for command line options */

   while( (*cpar == '-') || (*cpar == '/') )
   {
       partest++;
       if( *cpar == '/')
       {  /* Tetra file name */
           
       }
       else
       {
           cpar++;
           switch (*cpar)
           {

           case 'n' :
           case 'N' :       
               cpar++;
               if( *cpar != 0)
               {
                  OptimizePalette = atoi(cpar);
                  if( (OptimizePalette < 64) || (OptimizePalette > 256 ) )
                          OptimizePalette = 256;
               }
               else
                  OptimizePalette = 255;
               break;


           case 'e' :
           case 'E' :
               cpar++;
               ERR = atoi(cpar);
               if( (ERR < 8) || (ERR > 50 ) ) ERR = 20;
               break;

           case 'c' :
           case 'C' :
               cpar++;
               if( (*cpar == 'd') || (*cpar == 'D') )
               {
                  cpar++;
                  DarkLimit = atoi(cpar);
                  if( (DarkLimit < 0) || (DarkLimit > 64 ) )
                       DarkLimit = 0;
               }
               else
               {
                  cpar++;
                  LiteLimit = atoi(cpar);
                  if( (LiteLimit < 191) || (LiteLimit > 255 ) )
                       LiteLimit = 255;      

               }
               break;

           case 'a' :
           case 'A' :
               cpar++;
               GrayFactor = atoi(cpar);
               if( (GrayFactor < 50) || (GrayFactor > 400 ) )
                    GrayFactor = 100;
               break;

           case 'm' :
           case 'M' :
               cpar++;
               nMinPixels = atoi(cpar);
               if( (nMinPixels < 1) || (nMinPixels > 32000 ) )
                    nMinPixels = 50;
               break;

           case 'p' :
           case 'P' :
               cpar++;
               PCut = atoi(cpar);
               if( (PCut  < 0) || (PCut > 25 ) )
                    PCut = 5;
               PCut = (PCut*512L/100);
               break;

           case 'f' :
           case 'F' :
               Fixed = 1;
               break;

           case 'i' :
           case 'I' :
               cpar++;
               UnGamma = atoi(cpar);
               if( (UnGamma < 10) || (UnGamma > 30 ) ) UnGamma = 10;
               break;

           case 'd' :
           case 'D' :
               NoFast = 1;
               break;


           case 'w' :
           case 'W' :
               cpar++;

               if( strlen(cpar) < 3) break;

               wRed = *(cpar++) - '0';
               if( wRed < 1) wRed = 1;
               if( wRed > 8) wRed = 8;
               wGreen = *(cpar++) - '0';
               if( wGreen < 1) wGreen = 1;
               if( wGreen > 8) wGreen = 8;
               wBlue = *cpar - '0';
               if( wBlue < 1) wBlue = 1;
               if( wBlue > 8) wBlue = 8;
               if( (wRed + wGreen + wBlue) > 10 )
               { /* error */
                 wRed = 2;
                 wGreen = 3;
                 wBlue = 1;
               }
               break;

           case 'r' :
           case 'R' :
               cpar++;
               rBits = atoi(cpar);
               if( (rBits < 0) || (rBits > 4) ) rBits = 3;
               break;


           case 'g' :
           case 'G' :
               cpar++;
               gBits = atoi(cpar);
               if( (gBits < 0) || (gBits > 4) ) gBits = 2;
               break;

           case 'b' :
           case 'B' :
               cpar++;
               bBits = atoi(cpar);
               if( (bBits < 0) || (bBits > 4) ) bBits = 3;
               break;


           case 'o' :
           case 'O' :
               cpar++;
               if( *cpar == 0)
               {
                   GammaValue = 20;
                   break;
               }
               GammaValue = atoi(cpar);
               if( GammaValue < 10) GammaValue = 10;
               if( GammaValue > 30) GammaValue = 30;
               break;

           default:
                printf(" Incorrect Switch -? ");
                return(1);
           }
       }
       cpar = argv[partest + 1];
   }

   if (argc < (partest + 2))
   { /* no files, list syntax and options */
      printf(" %s\n\n",syntax);
      for(k = 0; options[k] != NULL; k++)
      printf("%s\n",options[k]);
      return(0);
   }



   /* open the source file */
   fnsplit(argv[partest + 1],drive,dir,file,ext);

   if (ext[0] == '\0')
      strcpy(ext,".tga");
   fnmerge(s,drive,dir,file,ext);
   hTga = _open(s,O_RDONLY);
   if (hTga < 0)
   {
      printf(" Source File %s%s Not Found\n",file,ext);
      return(1);
   }
   

  /* check if source is a tga file and setup read buffer */
   if(!Fixed)
      printf("Analyzing Image.\n");

   if(ReadTgaInfo())
   { /* not a supported tga file */
      printf("File %s%s not a supported tga file\n",file,ext);
      close(hTga);
      return(0);
   }

   /* open gif file */

   if (argc > (partest + 2) )
   { /* output file in command line */
       fnsplit(argv[partest + 2],drive,dir,file,ext);
       if (ext[0] == '\0')
       strcpy(ext,".gif");
   }
   else
   { /* make output from input */
       strcpy(ext,".gif");     
   }
   fnmerge(s,drive,dir,file,ext);
   hGif = _creat(s,0);

   if (hGif < 0)
   {
      printf(" Output File %s%s Cannot be Opened\n",file,ext);
      close(hTga);
      return(1);
   }

    SetGamma(GammaValue);
    SetInverseGamma(UnGamma);

    InitCodeSize = CalculatePalette(OptimizePalette);
    if(InitCodeSize < 1)
    {
        printf("\n\n Palette Error");
        printf("\n Number Tetra = %d",MAXTETRA - kNextTetra);
        return(0);
    }
    if(!InitColorLookup() )
    {
         InitFloydPic();
         EncodeGif(TgaImageInfo.Width,TgaImageInfo.Height,0,InitCodeSize);
    }
    else
      parse_error = 1;
   
   close(hTga);
   close(hGif);
    printf("Done.");
    if(!Fixed)
       printf("\n\nNumber of colors in image = %d",MAXRGB - kNextRgb);
    printf("\nNumber of Tetrahedrons = %d",MAXTETRA - kNextTetra);
 

   if(parse_error)
   {
      unlink(s);
      printf("\n Conversion error");
   }
#ifdef TEST
     printf("\n maxerror = %u",tmaxerror);
     printf("\n max error color = (%4u,%4u,%4u)",
     tcolorerror[0],tcolorerror[1],tcolorerror[2]);
#endif
   return(0);
}




