#include <iostream.h>
#include <stdio.h>
#include <string.h>

#include "dskarr.h" 		// defines the Expandable Disk Array Type

/**************************************************************
Examples of Use of General Expandable Disk Arrays
Bill Honey, 1993

General Useage:

	DskArray< data_type > myArray(startSZ, memSZ, increaseSZ)

	startSZ is the initial number of elements (held on disk) in the array.
   memSZ is the number of elements held in the memory buffer.
   increaseSZ is the number of elements to increase the disk array size by
   	every time in needs enlarging (see text)

**************************************************************/

main()
{
int i;

/**************************************************************
*                                                             *
*	Example 1: An array of ints (simple useage)                *
*                                                             *
**************************************************************/

// an array of (initially) 10 ints
DskArray<int> intarr(10);

// Fill the array
	for (i = 0; i < 20; i++)  // NB DOES NOT CRASH WHEN IT PASSES 10
		intarr[i] = i;
// print its contents
   for (i = 0; i < 20; i++)
		cout << intarr[i] << "\n";

/**************************************************************
*                                                             *
*	Example 2: An array of Strings                             *
*  (declaring the memory buffer size)                         *
*                                                             *
**************************************************************/

typedef char str40[41];

// an array of (initially) 30 Strings, 15 of which will be held in memory
DskArray<str40> strarray(30,15);

// fill the array
	for (i = 0; i < 40; i++) 
		strcpy(strarray[i],"Hello World\n");
// print its contents
   for (i = 0; i < 40; i++)
		cout << strarray[i];

/**************************************************************
*                                                             *
*	Example 3: An array of classes                             *
*  (declaring the both the memory buffer size,                *
*      and the increase size)                                 *
*                                                             *
**************************************************************/
// declare a simple class with constructors and overloaded output function
class myClass {
	int x;
	float y;
public:
	myClass() { x = 0; y = 0.0;};
	myClass(int ix, float iy){ x = ix; y = iy;};
	friend ostream & operator << (ostream & os, myClass & mc) {
		os << "(" << mc.x << "," << mc.y << ")\n";
		return os;
	};
};


// An array of (initially) 100 myClass's ,
// 20 of which will be held in memory, with a self increase size of 15
DskArray <myClass> clsarray(100,20,15);

// fill the array
	for (i = 0; i < 250; i++)
		clsarray[i] = myClass(i,i);
// print its contents
   for (i = 0; i < 40; i++)
		cout << clsarray[i];
}

