#ifndef D_DPRN
#define D_DPRN

#include <iostream.h>

#ifndef BOOL
	#define BOOL unsigned char
#endif

#ifndef TRUE
	#define FALSE (0)
	#define TRUE (!FALSE)
#endif

class waitprinter {
	void loadstatus (int port); // get printer status
protected:
	int   errorx;               // x error write location (default=1)
	int   errory;               // y error write location (default=2)
	int  returnstatus (int port);       // return printer status
	BOOL istimeout (int port);          // is the printer timed out ?
	BOOL isioerror (int port);          // does printer have i/o error ?
	BOOL isselected (int port);         // is printer selected ?
	BOOL isoutofpaper (int port);       // is printer out of paper ?
	BOOL isacknowledged (int port);     // does printer acknowledge ?
	BOOL isnotbusy (int port);          // is printer NOT busy ?
public:
	waitprinter (void);
	void showprintererror (void);       // show printer problem
	void setprintererror (BOOL showit); // show user printer error
	void waitforprinter (BOOL wait);    // wait until printer responds
	BOOL printeron (int port);          // is a printer active ?
	void seterrorx (int x) {errorx=x;}  // set error x print loc
	void seterrory (int y) {errory=y;}  // set error y print loc
};  // waitprinter


class controlprinter{
protected:
	char  escape;        // esc char to set printer (default=0x1b)
public:
	controlprinter(char esc=0x1b);
	void setescape (char esc) {escape=esc;}// set new escape control code
	void setcontrols (void);               // clear control line & add escape
	void setcontrols (char ch);            // add control to control line
};  // class controlprinter

class pageprinter{
protected:
	char  *header;       // header line that will print
	int   maxlinelen;    // max allowed 'line' (default=133)
	int   maxlines;      // max lines on page (default=66)
	int   maxprintlines; // max # of printed lines on a page (default=56)
	int   linenum;       // print location on page
	int   pagenum;       // page number
	int   headerloc;     // line # header will print on (default=2)
	int   footerloc;     // line # page # will print on (default=max lines-1)
	BOOL  newpage;       // is this a new page with nothing printed on it ?
public:
	pageprinter (int linelen);
	~pageprinter (void);
	void setmaxpageleng (int totlines);           // Max lines on page
	void includepagenotice (BOOL on);             // Include 'Page' notice
	void setheaderloc(int line) {headerloc=line;} // Set loc header prints at
	void setfooterloc(int line) {footerloc=line;} // Set loc footer prints at 
	void headeron (BOOL on);                      // print header ??
	void saveheader (void);                       // save your header line
	void pageon (BOOL on);                        // print page # ??
	int  getmaxpagelen (void);                    // Get max lines on page
	void setprintlines (int totlines);            // Max printed lines
	int  getprintlines (void);                    // Get max print lines
	void setheaderleng (int totlines);            // Total header linefeeds
	void settrackpage  (BOOL usepage=TRUE);       // Turn auto paging on/off
	void setlinenumber (int line) {linenum=line;} // Set the line number
	void setpagenumber (int page) {pagenum=page;} // Set the page number
	int  getlinenumber (void) {return linenum;}   // Get the line number
	int  getpagenumber (void) {return pagenum;}   // Get the page number
	BOOL getnewpage (void) {return newpage;}      // New page ?
	void setnewpage (BOOL isnew) {newpage=isnew;} // Set newpage
};

class printer : public controlprinter, public pageprinter, 
								public waitprinter {
	void writepagenum (void);  // write page # on page
protected:
	void setprinter (int port=99);        // send control code to printer
public:
	printer(int port=0, int maxlinesize=133, int maxprint=79);
	~printer(void);       
	void setmaxprint (int size = 79);     // max line size sent to printer
	void sendcontrols (void);             // send control line to printer
	void sendcontrols (char ch);          // send single byte printer control
	void writeheader (void);              // Add blank header on page
	void formfeed (void);                 // do a page formfeed
	void checkpage (void);     	          // do new page if max lines
	void write (char *s);                 // print s without cr/lf
	void writeln (char *s);               // print s with cr/lf
	void writeln (void);                  // print cr/lf
	void printline (void);                // print line with cr/lf
	void putprint (void);                 // clear (nul) print line
	void putprint (int  x,  int loc=0);   // stuff x in line at loc
	void putprint (char *s, int loc=0);   // stuff s in line at loc
	void putprint (long x,  int loc=0);   // stuff x in line at loc
	void getline (char *s);               // save line in s
};

#endif
